/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ui.chart.viewer.profile;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.emf.databinding.EMFObservables;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.scada.ui.chart.model.ChartPackage;
import org.eclipse.scada.ui.chart.model.Profile;
import org.eclipse.scada.ui.chart.viewer.ChartContext;
import org.eclipse.scada.ui.chart.viewer.controller.ControllerManager;
import org.eclipse.scada.ui.chart.viewer.profile.ProfileManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfileEntry {
    private static final Logger logger = LoggerFactory.getLogger(ProfileEntry.class);
    private final ProfileManager manager;
    private final Profile profile;
    private boolean active;
    private final DataBindingContext ctx;
    private ControllerManager controllerManager;
    private final ChartContext chartContext;
    private final Set<Binding> bindings = new HashSet<Binding>();
    private Binding controllerBinding;

    public ProfileEntry(DataBindingContext ctx, ProfileManager manager, Profile profile, ChartContext chartContext) {
        this.ctx = ctx;
        this.chartContext = chartContext;
        this.manager = manager;
        this.profile = profile;
    }

    public void activate() {
        if (this.active) {
            return;
        }
        this.active = true;
        logger.info("Activate profile: {}", (Object)this.profile.getId());
        this.controllerManager = new ControllerManager(this.ctx, this.ctx.getValidationRealm(), this.chartContext);
        this.controllerBinding = this.ctx.bindList((IObservableList)this.controllerManager.getList(), EMFObservables.observeList((EObject)this.profile, (EStructuralFeature)ChartPackage.Literals.PROFILE__CONTROLLERS));
    }

    protected void addBinding(Binding binding) {
        this.bindings.add(binding);
    }

    public void deactivate() {
        if (!this.active) {
            return;
        }
        this.active = false;
        logger.info("Deactivate profile: {}", (Object)this.profile.getId());
        if (this.controllerBinding != null) {
            this.controllerBinding.dispose();
            this.controllerBinding = null;
        }
        if (this.controllerManager != null) {
            this.controllerManager.dispose();
            this.controllerManager = null;
        }
    }

    protected void fireSelection(boolean selection) {
        if (selection) {
            this.manager.setActiveProfile(this.profile);
        } else {
            this.manager.setActiveProfile(null);
        }
    }

    public void dispose() {
        this.deactivate();
        for (Binding b : this.bindings) {
            b.dispose();
        }
        this.bindings.clear();
    }
}

