/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.vi.ui.chart.draw2d;

import org.eclipse.draw2d.TextUtilities;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.jface.resource.ColorDescriptor;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.DeviceResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.scada.chart.swt.Graphics;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.LineAttributes;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;

public class Draw2DGraphics
implements Graphics {
    private final org.eclipse.draw2d.Graphics g;
    private final ResourceManager resourceManager;

    public Draw2DGraphics(org.eclipse.draw2d.Graphics g, Device device) {
        this.g = g;
        this.resourceManager = new DeviceResourceManager(device);
    }

    public void dispose() {
        this.resourceManager.dispose();
    }

    public void setAlpha(int alpha) {
        this.g.setAlpha(alpha);
    }

    public void setLineAttributes(LineAttributes lineAttributes) {
        this.g.setLineAttributes(lineAttributes);
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        this.g.drawLine(x1, y1, x2, y2);
    }

    public void fillRectangle(int x, int y, int width, int height) {
        this.g.fillRectangle(x, y, width, height);
    }

    public void setForeground(RGB color) {
        this.g.setForegroundColor((Color)this.resourceManager.get((DeviceResourceDescriptor)ColorDescriptor.createFrom((RGB)color)));
    }

    public void setBackground(RGB color) {
        this.g.setBackgroundColor((Color)this.resourceManager.get((DeviceResourceDescriptor)ColorDescriptor.createFrom((RGB)color)));
    }

    public void setClipping(Rectangle rect) {
        if (rect == null) {
            this.g.setClip(null);
        } else {
            this.g.setClip(new org.eclipse.draw2d.geometry.Rectangle(rect.x, rect.y, rect.width, rect.height));
        }
    }

    public void drawRectangle(int x, int y, int width, int height) {
        this.g.drawRectangle(x, y, width, height);
    }

    public void drawRectangle(Rectangle rect) {
        this.g.drawRectangle(rect.x, rect.y, rect.width, rect.height);
    }

    public Path createPath() {
        return new Path((Device)Display.getCurrent());
    }

    public void drawPath(Path path) {
        this.g.drawPath(path);
    }

    public void fillRectangle(Rectangle rect) {
        this.g.fillRectangle(rect.x, rect.y, rect.width, rect.height);
    }

    public void drawText(String string, int x, int y, Float rotate) {
        if (rotate != null) {
            this.g.pushState();
            this.g.rotate(rotate.floatValue());
        }
        this.g.drawText(string, x, y);
        if (rotate != null) {
            this.g.popState();
        }
    }

    public Point textExtent(String string) {
        Dimension result = TextUtilities.INSTANCE.getTextExtents(string, this.g.getFont());
        return new Point(result.width, result.height);
    }

    public FontMetrics getFontMetrics() {
        return this.g.getFontMetrics();
    }

    public void setAntialias(boolean state) {
        this.g.setAntialias(state ? 1 : 0);
    }

    public void setFont(Font font) {
        this.g.setFont(font);
    }

    public ResourceManager getResourceManager() {
        return this.resourceManager;
    }

    public void drawRoundRectangle(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.g.drawRoundRectangle(new org.eclipse.draw2d.geometry.Rectangle(x, y, width, height), arcWidth, arcHeight);
    }

    public void fillRoundRectangle(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.g.fillRoundRectangle(new org.eclipse.draw2d.geometry.Rectangle(x, y, width, height), arcWidth, arcHeight);
    }
}

