/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.client.dataitem.details.extra.part;

import java.util.HashMap;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.da.client.dataitem.details.extra.part.GenericLevelPresets;
import org.eclipse.scada.sec.callback.CallbackHandler;

public class LocalLevelPresets
extends GenericLevelPresets {
    private static final String[] TAGS = new String[]{"min", "lowlow", "low", "high", "highhigh", "max"};

    @Override
    protected boolean isUnsafe(String string) {
        return this.getBooleanAttribute(String.format("org.eclipse.scada.ae.monitor.level.%s.unsafe", string));
    }

    @Override
    protected boolean isActive(String string) {
        return this.getBooleanAttribute(String.format("org.eclipse.scada.ae.monitor.level.%s.active", string));
    }

    @Override
    protected Number getPreset(String string) {
        return this.getNumberAttribute(String.format("org.eclipse.scada.ae.monitor.level.%s.preset", string), null);
    }

    @Override
    protected boolean isCapped() {
        return this.hasAttribute("org.eclipse.scada.ae.monitor.level.value.original");
    }

    @Override
    protected Variant getOriginalValue() {
        return (Variant)this.value.getAttributes().get("org.eclipse.scada.ae.monitor.level.value.original");
    }

    @Override
    protected boolean isAlarm(String string) {
        return this.getBooleanAttribute(String.format("org.eclipse.scada.ae.monitor.level.%s.alarm", string));
    }

    @Override
    protected boolean isWarning(String string) {
        return this.getBooleanAttribute(String.format("org.eclipse.scada.ae.monitor.level.%s.warning", string));
    }

    @Override
    protected boolean isError(String string) {
        return this.getBooleanAttribute(String.format("org.eclipse.scada.ae.monitor.level.%s.error", string));
    }

    @Override
    protected boolean isAckRequired(String string, String severity) {
        return this.getBooleanAttribute(String.format("org.eclipse.scada.ae.monitor.level.%s.%s.ackRequired", string, severity));
    }

    @Override
    protected void setPreset(Variant value, boolean active, String tag) {
        HashMap<String, Variant> attributes = new HashMap<String, Variant>(2);
        attributes.put(String.format("org.eclipse.scada.ae.monitor.level.%s.preset", tag), value);
        attributes.put(String.format("org.eclipse.scada.ae.monitor.level.%s.active", tag), Variant.valueOf((boolean)active));
        this.item.writeAtrtibutes(attributes, null, (CallbackHandler)this.makeDisplayCallback());
    }

    @Override
    protected void setActive(boolean state, String tag) {
        HashMap<String, Variant> attributes = new HashMap<String, Variant>(1);
        attributes.put(String.format("org.eclipse.scada.ae.monitor.level.%s.active", tag), state ? Variant.TRUE : Variant.FALSE);
        this.item.writeAtrtibutes(attributes, null, (CallbackHandler)this.makeDisplayCallback());
    }

    @Override
    protected boolean isAvailable() {
        String[] stringArray = TAGS;
        int n = TAGS.length;
        int n2 = 0;
        while (n2 < n) {
            String tag = stringArray[n2];
            if (this.hasAttribute(String.format("org.eclipse.scada.ae.monitor.level.%s.active", tag))) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    protected String getMinTag() {
        return "min";
    }

    @Override
    protected String getMaxTag() {
        return "max";
    }

    @Override
    protected String getHighHighTag() {
        return "highhigh";
    }

    @Override
    protected String getHighTag() {
        return "high";
    }

    @Override
    protected String getLowTag() {
        return "low";
    }

    @Override
    protected String getLowLowTag() {
        return "lowlow";
    }
}

