/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.hd.ui.connection.internal;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.core.databinding.observable.set.WritableSet;
import org.eclipse.scada.core.ui.connection.ConnectionDescriptor;
import org.eclipse.scada.core.ui.connection.data.ConnectionHolder;
import org.eclipse.scada.hd.connection.provider.ConnectionService;
import org.eclipse.scada.hd.ui.connection.internal.ItemListWrapper;
import org.eclipse.scada.hd.ui.connection.internal.QueryWrapper;

public class ConnectionWrapper
extends WritableSet
implements PropertyChangeListener {
    private final ConnectionHolder holder;
    private ConnectionService service;
    private QueryWrapper queryManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectionWrapper(ConnectionHolder target) {
        this.holder = target;
        ConnectionWrapper connectionWrapper = this;
        synchronized (connectionWrapper) {
            this.holder.addPropertyChangeListener("connectionService", (PropertyChangeListener)this);
            this.triggerUpdate();
        }
    }

    public synchronized void dispose() {
        this.holder.removePropertyChangeListener("connectionService", (PropertyChangeListener)this);
        super.dispose();
    }

    @Override
    public synchronized void propertyChange(PropertyChangeEvent evt) {
        this.triggerUpdate();
    }

    private void triggerUpdate() {
        this.getRealm().asyncExec(new Runnable(){

            @Override
            public void run() {
                ConnectionWrapper.this.update();
            }
        });
    }

    private void update() {
        this.setStale(true);
        try {
            ConnectionService service;
            this.clearConnection();
            this.service = service = (ConnectionService)this.holder.getConnectionService();
            if (this.service != null) {
                this.queryManager = new QueryWrapper(service);
                this.add(this.queryManager);
                this.add(new ItemListWrapper(this));
            }
        }
        finally {
            this.setStale(false);
        }
    }

    public QueryWrapper getQueryManager() {
        return this.queryManager;
    }

    private void clearConnection() {
        this.clear();
        this.service = null;
        if (this.queryManager != null) {
            this.queryManager.dispose();
        }
    }

    public ConnectionService getService() {
        return this.service;
    }

    public ConnectionDescriptor getDescriptor() {
        return this.holder.getConnectionInformation();
    }
}

