/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.ui.client.signalgenerator.page;

import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.scada.da.ui.client.signalgenerator.page.AbstractStepGeneratorPage;
import org.eclipse.scada.da.ui.client.signalgenerator.page.AnalogType;
import org.eclipse.scada.da.ui.client.signalgenerator.page.Messages;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class AnalogPage
extends AbstractStepGeneratorPage {
    private Text minText;
    private Text maxText;
    private Combo functionCombo;
    private ComboViewer functionComboViewer;
    private Text perText;
    private double minimum;
    private double maximum;
    private double selectedPeriod;
    private AnalogType function;
    private Text freqText;

    @Override
    public void createPage(Composite parent) {
        super.createPage(parent);
        parent.setLayout((Layout)new FillLayout(512));
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout(2, false));
        ModifyListener updateAdapter = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AnalogPage.this.updateSelection();
            }
        };
        Label label = new Label(comp, 0);
        label.setText(Messages.getString("AnalogPage.PresetMin"));
        this.minText = new Text(comp, 2052);
        this.minText.setText("-20");
        this.minText.addModifyListener(updateAdapter);
        this.minText.setLayoutData(this.labelData());
        label = new Label(comp, 0);
        label.setText(Messages.getString("AnalogPage.PresetMax"));
        this.maxText = new Text(comp, 2052);
        this.maxText.setText("20");
        this.maxText.addModifyListener(updateAdapter);
        this.maxText.setLayoutData(this.labelData());
        label = new Label(comp, 0);
        label.setText(Messages.getString("AnalogPage.PresetFrequency"));
        this.freqText = new Text(comp, 2052);
        this.freqText.setText("2000");
        this.freqText.addModifyListener(updateAdapter);
        this.freqText.setLayoutData(this.labelData());
        label = new Label(comp, 0);
        label.setText(Messages.getString("AnalogPage.PresetPeriod"));
        this.perText = new Text(comp, 2052);
        this.perText.setText("250");
        this.perText.addModifyListener(updateAdapter);
        this.perText.setLayoutData(this.labelData());
        label = new Label(comp, 0);
        label.setText(Messages.getString("AnalogPage.PresetFunction"));
        this.functionCombo = new Combo(comp, 12);
        this.functionCombo.setLayoutData(this.labelData());
        this.functionComboViewer = new ComboViewer(this.functionCombo);
        this.functionComboViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.functionComboViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof AnalogType) {
                    return ((AnalogType)((Object)element)).toLabel();
                }
                return super.getText(element);
            }
        });
        this.functionComboViewer.add((Object[])AnalogType.values());
        this.functionComboViewer.setSelection((ISelection)new StructuredSelection((Object)AnalogType.values()[0]), true);
        this.functionComboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AnalogPage.this.updateSelection();
            }
        });
        this.updateSelection();
    }

    private Object labelData() {
        GridData data = new GridData(4, 0x1000000, false, false);
        return data;
    }

    protected void updateSelection() {
        this.minimum = this.getMinimum();
        this.maximum = this.getMaximum();
        this.selectedPeriod = this.getFrequency();
        this.function = this.getFunction();
        this.setPeriod(this.getPeriod());
    }

    protected double getMinimum() {
        try {
            return Double.parseDouble(this.minText.getText());
        }
        catch (Throwable throwable) {
            return Double.MIN_VALUE;
        }
    }

    protected double getMaximum() {
        try {
            return Double.parseDouble(this.maxText.getText());
        }
        catch (Throwable throwable) {
            return Double.MAX_VALUE;
        }
    }

    protected double getFrequency() {
        try {
            return Double.parseDouble(this.freqText.getText());
        }
        catch (Throwable throwable) {
            return 20000.0;
        }
    }

    protected long getPeriod() {
        try {
            return Long.parseLong(this.perText.getText());
        }
        catch (Throwable throwable) {
            return 250L;
        }
    }

    protected AnalogType getFunction() {
        return (AnalogType)((Object)((IStructuredSelection)this.functionComboViewer.getSelection()).getFirstElement());
    }

    @Override
    protected void step() {
        this.target.writeValue(this.function.generate(System.currentTimeMillis(), this.minimum, this.maximum, this.selectedPeriod));
    }
}

