/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.vi.details.swt.widgets;

import java.util.Map;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.scada.vi.data.DataValue;
import org.eclipse.scada.vi.data.SummaryInformation;
import org.eclipse.scada.vi.details.swt.data.DataItemDescriptor;
import org.eclipse.scada.vi.details.swt.widgets.GenericComposite;
import org.eclipse.scada.vi.details.swt.widgets.control.ControlImage;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrowserComponent
extends GenericComposite {
    private static final Logger logger = LoggerFactory.getLogger(BrowserComponent.class);
    private final org.eclipse.scada.vi.details.model.BrowserComponent component;
    private final Browser browser;
    private final LocalResourceManager resourceManager;
    private String currentUrl;
    private Image currentImage;
    private final ControlImage controlImage;

    public BrowserComponent(Composite parent, int style, DataItemDescriptor descriptor, org.eclipse.scada.vi.details.model.BrowserComponent component) {
        super(parent, style, null, null);
        this.component = component;
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 3;
        layout.marginHeight = 3;
        layout.verticalSpacing = 3;
        layout.horizontalSpacing = 3;
        this.setLayout((Layout)layout);
        this.resourceManager = new LocalResourceManager(JFaceResources.getResources());
        this.controlImage = new ControlImage(this, this.registrationManager);
        this.browser = new Browser((Composite)this, 0);
        GridData gd = new GridData(0x1000000, 0x1000000, true, true);
        if (component.getHeight() != null && component.getWidth() != null) {
            gd.minimumHeight = component.getHeight();
            gd.minimumWidth = component.getWidth();
            this.browser.setSize(component.getWidth().intValue(), component.getHeight().intValue());
        }
        this.browser.setLayoutData((Object)gd);
        if (descriptor != null) {
            this.controlImage.setDetailItem(descriptor.asItem());
            this.registrationManager.registerItem("value", descriptor.getItemId(), descriptor.getConnectionInformation(), false, false);
        }
        this.showUrl(this.makeUrl());
        if (component.getReloadTimer() != null && component.getReloadTimer() > 0L) {
            this.triggerReload(component.getReloadTimer());
        }
    }

    private void triggerReload(final long delay) {
        if (this.browser.isDisposed()) {
            return;
        }
        if (this.browser.getDisplay().isDisposed()) {
            return;
        }
        this.browser.getDisplay().timerExec((int)delay, new Runnable(){

            @Override
            public void run() {
                if (!BrowserComponent.this.browser.isDisposed()) {
                    BrowserComponent.this.reload();
                    BrowserComponent.this.triggerReload(delay);
                }
            }
        });
    }

    private String makeUrl() {
        if (this.component.getUrl() == null) {
            return "about:blank";
        }
        return this.component.getUrl();
    }

    @Override
    protected void handleDispose() {
        if (this.currentImage != null) {
            this.currentImage.dispose();
            this.currentImage = null;
        }
        this.resourceManager.dispose();
    }

    @Override
    protected void updateState(Map<String, DataValue> values, SummaryInformation aggregatedState) {
        if (this.isDisposed()) {
            logger.info("No updateView cause widget is disposed");
            return;
        }
        this.showUrl(this.makeUrl());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void showUrl(String url) {
        logger.debug("Requesting URL: {}", (Object)url);
        BrowserComponent browserComponent = this;
        synchronized (browserComponent) {
            if (this.currentUrl != null && this.currentUrl.equals(url)) {
                logger.debug("URL did not change");
                return;
            }
            this.currentUrl = url;
            this.browser.setUrl(this.currentUrl);
        }
    }

    public void reload() {
        this.browser.refresh();
    }
}

