/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.ui.widgets;

import org.eclipse.scada.core.ui.styles.StateInformation;
import org.eclipse.scada.core.ui.styles.StateStyler;
import org.eclipse.scada.core.ui.styles.StyleBlinker;
import org.eclipse.scada.core.ui.styles.StyleHandler;
import org.eclipse.scada.da.client.DataItemValue;
import org.eclipse.scada.da.ui.connection.data.DataItemHolder;
import org.eclipse.scada.da.ui.connection.data.DataSourceListener;
import org.eclipse.scada.da.ui.connection.data.Item;
import org.eclipse.scada.da.ui.styles.DataItemValueStateExtractor;
import org.eclipse.scada.da.ui.widgets.Messages;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.osgi.framework.BundleContext;

public class DataItemHeaderLabel
extends Composite {
    private final Label headerIcon;
    private final Label headerLabel;
    private final Label headerValueLabel;
    private final StyleBlinker blinker;
    private final StateStyler styler;
    private final DataSourceListener listener = new DataSourceListener(){

        public void updateData(DataItemValue value) {
            DataItemHeaderLabel.this.handleUpdateData(value);
        }
    };
    private DataItemHolder holder;

    public DataItemHeaderLabel(Composite parent) {
        super(parent, 0);
        this.setLayout((Layout)new RowLayout(256));
        this.headerIcon = new Label((Composite)this, 0);
        this.headerLabel = new Label((Composite)this, 0);
        this.headerLabel.setText(Messages.DataItemHeaderLabel_EmptyDataItem);
        this.headerValueLabel = new Label((Composite)this, 0);
        this.blinker = new StyleBlinker(){

            public void update(StyleBlinker.CurrentStyle style) {
                DataItemHeaderLabel.this.handleStyleUpdate(style);
            }
        };
        this.styler = new StateStyler((StyleHandler)this.blinker);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                DataItemHeaderLabel.this.handleDispose();
            }
        });
        this.handleUpdateData(null);
    }

    protected void handleDispose() {
        this.unsubscribe();
        this.styler.dispose();
        this.blinker.dispose();
    }

    public void subscribe(BundleContext context, Item item) {
        this.unsubscribe();
        if (item != null) {
            this.holder = new DataItemHolder(context, item, this.listener);
            this.headerLabel.setText(String.format(Messages.DataItemHeaderLabel_DataItemFormat, item.getId()));
            this.layout();
        }
    }

    public void unsubscribe() {
        if (this.holder != null) {
            this.holder.dispose();
            this.holder = null;
            this.headerLabel.setText(Messages.DataItemHeaderLabel_EmptyDataItem);
            this.layout();
        }
    }

    protected void handleStyleUpdate(StyleBlinker.CurrentStyle style) {
        if (this.isDisposed()) {
            return;
        }
        DataItemHeaderLabel.applyWidget((Control)this.headerValueLabel, style);
        DataItemHeaderLabel.applyWidget((Control)this, style);
        DataItemHeaderLabel.applyWidget((Control)this.headerLabel, style);
        DataItemHeaderLabel.applyWidget(this.headerIcon, style);
        this.layout();
    }

    private static void applyWidget(Label label, StyleBlinker.CurrentStyle style) {
        DataItemHeaderLabel.applyWidget((Control)label, style);
        label.setImage(style.image);
    }

    private static void applyWidget(Control label, StyleBlinker.CurrentStyle style) {
        label.setForeground(style.foreground);
        label.setBackground(style.background);
        label.setFont(style.font);
    }

    protected void handleUpdateData(final DataItemValue value) {
        this.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                DataItemHeaderLabel.this.performUpdate(value);
            }
        });
    }

    private void performUpdate(DataItemValue value) {
        if (this.headerValueLabel.isDisposed()) {
            return;
        }
        this.styler.style((StateInformation)new DataItemValueStateExtractor(value));
        if (value == null) {
            this.headerValueLabel.setText(Messages.DataItemHeaderLabel_NoValueText);
            return;
        }
        this.headerValueLabel.setText(value.toString());
        this.layout();
    }
}

