/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.vi.ui.draw2d;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.script.ScriptContext;
import javax.script.SimpleScriptContext;
import org.eclipse.emf.common.util.URI;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.core.ui.styles.StyleGenerator;
import org.eclipse.scada.sec.callback.CallbackHandler;
import org.eclipse.scada.sec.ui.DisplayCallbackHandler;
import org.eclipse.scada.ui.utils.status.StatusHelper;
import org.eclipse.scada.utils.script.ScriptExecutor;
import org.eclipse.scada.vi.data.DataValue;
import org.eclipse.scada.vi.data.RegistrationManager;
import org.eclipse.scada.vi.data.SummaryInformation;
import org.eclipse.scada.vi.data.SummaryListener;
import org.eclipse.scada.vi.model.Primitive;
import org.eclipse.scada.vi.model.Symbol;
import org.eclipse.scada.vi.ui.draw2d.Activator;
import org.eclipse.scada.vi.ui.draw2d.ConsoleContext;
import org.eclipse.scada.vi.ui.draw2d.FactoryContext;
import org.eclipse.scada.vi.ui.draw2d.ScriptManager;
import org.eclipse.scada.vi.ui.draw2d.SymbolContext;
import org.eclipse.scada.vi.ui.draw2d.SymbolData;
import org.eclipse.scada.vi.ui.draw2d.loader.SymbolLoader;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.statushandlers.StatusManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.profiler.Profiler;

public class SymbolController
implements RegistrationManager.Listener {
    private static final Logger logger = LoggerFactory.getLogger(SymbolController.class);
    private final SymbolController parentController;
    private final Set<SymbolController> controllers = new LinkedHashSet<SymbolController>();
    private final ScriptExecutor onInit;
    private final ScriptExecutor onDispose;
    private final ScriptExecutor onUpdate;
    private final Properties properties;
    private final SymbolContext context;
    private final ScriptContext scriptContext;
    private final Map<String, Object> elements = new HashMap<String, Object>();
    private final Map<Primitive, Object> primitives = new HashMap<Primitive, Object>();
    private RegistrationManager registrationManager;
    private final SymbolData symbolData;
    private Map<String, DataValue> lastData;
    private final Set<SummaryListener> summaryListeners = new LinkedHashSet<SummaryListener>(1);
    private final Map<String, Object> scriptObjects;
    private ConsoleContext console;
    private MessageConsole createdConsole;
    private final String symbolInfoName;
    private final List<String> nameHierarchy;
    private final StyleGenerator.GeneratorListener generatorListener = new StyleGenerator.GeneratorListener(){

        public void configurationChanged() {
            SymbolController.this.generatorConfigurationChanged();
        }
    };
    private final StyleGenerator generator;
    private final Shell shell;
    private final SymbolLoader symbolLoader;
    private final FactoryContext factoryContext;
    private final ScriptManager scriptManager;

    public SymbolController(Shell shell, SymbolLoader symbolLoader, Map<String, String> properties, Map<String, Object> scriptObjects, FactoryContext factoryContext) throws Exception {
        this(shell, null, symbolLoader, properties, scriptObjects, factoryContext, new ScriptManager());
    }

    public SymbolController(Shell shell, SymbolController parentController, SymbolLoader symbolLoader, Map<String, String> properties, Map<String, Object> scriptObjects, FactoryContext factoryContext) throws Exception {
        this(shell, parentController, symbolLoader, properties, scriptObjects, factoryContext, parentController.scriptManager);
    }

    private SymbolController(Shell shell, SymbolController parentController, SymbolLoader symbolLoader, Map<String, String> properties, Map<String, Object> scriptObjects, FactoryContext factoryContext, ScriptManager scriptManager) throws Exception {
        Profiler p = new Profiler("SymbolController");
        p.start("init");
        this.shell = shell;
        this.symbolLoader = symbolLoader;
        this.symbolInfoName = symbolLoader.getSourceName();
        this.parentController = parentController;
        this.factoryContext = factoryContext;
        this.scriptManager = scriptManager;
        this.generator = org.eclipse.scada.core.ui.styles.Activator.getDefaultStyleGenerator();
        this.nameHierarchy = this.makeNameHierarchy();
        p.start("data");
        this.symbolData = new SymbolData(this);
        this.registrationManager = new RegistrationManager(Activator.getDefault().getBundle().getBundleContext(), this.symbolInfoName);
        this.registrationManager.addListener((RegistrationManager.Listener)this);
        this.registrationManager.open();
        p.start("load");
        Symbol symbol = symbolLoader.loadSymbol();
        this.properties = parentController != null ? new Properties(parentController.getProperties()) : new Properties();
        for (Map.Entry entry : symbol.getProperties().entrySet()) {
            if (entry.getValue() == null) continue;
            this.properties.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry entry : properties.entrySet()) {
            if (entry.getValue() == null) continue;
            this.properties.put(entry.getKey(), entry.getValue());
        }
        p.start("ctx");
        this.context = new SymbolContext(this);
        if (parentController != null) {
            parentController.addChild(this);
        }
        p.start("console");
        this.scriptContext = new SimpleScriptContext();
        this.assignConsole(this.scriptContext);
        p.start("add scripts");
        this.scriptContext.setAttribute("controller", this.context, 100);
        this.scriptContext.setAttribute("data", this.symbolData, 100);
        this.scriptContext.setAttribute("GSON", this.createJson(), 100);
        this.scriptContext.setAttribute("styleGenerator", this.generator, 100);
        this.scriptObjects = scriptObjects;
        this.addScriptObjects(scriptObjects);
        if (parentController != null) {
            this.addScriptObjects(parentController.getScriptObjects());
        }
        p.start("load scripts");
        for (String string : symbol.getScriptModules()) {
            this.loadScript(string);
        }
        p.start("parse");
        this.onInit = this.scriptManager.parse(symbol.getOnInit(), "onInit");
        this.onDispose = this.scriptManager.parse(symbol.getOnDispose(), "onDispose");
        this.onUpdate = this.scriptManager.parse(symbol.getOnUpdate(), "onUpdate");
        p.start("add listener");
        this.generator.addListener(this.generatorListener);
    }

    public Shell getShell() {
        return this.shell;
    }

    protected void generatorConfigurationChanged() {
        this.runUpdate(true);
    }

    private List<String> makeNameHierarchy() {
        LinkedList<String> result = new LinkedList<String>();
        SymbolController current = this;
        while (current != null) {
            result.add(0, current.symbolInfoName);
            current = current.parentController;
        }
        return Collections.unmodifiableList(result);
    }

    private void assignConsole(ScriptContext scriptContext) {
        this.console = this.createOrGetConsole();
        this.console.applyTo(scriptContext);
    }

    private ConsoleContext createOrGetConsole() {
        if (this.parentController != null && this.parentController.getConsole() != null) {
            return this.parentController.getConsole();
        }
        IConsoleManager manager = ConsolePlugin.getDefault().getConsoleManager();
        MessageConsole messageConsole = new MessageConsole(String.format("Symbol Debug Console: %s", this.symbolInfoName), null, null, true);
        manager.addConsoles(new IConsole[]{messageConsole});
        this.createdConsole = messageConsole;
        return new ConsoleContext(messageConsole);
    }

    protected ConsoleContext getConsole() {
        if (this.console != null) {
            return this.console;
        }
        return null;
    }

    private Gson createJson() {
        return new GsonBuilder().serializeNulls().setDateFormat("yyyy-MM-dd hh:mm:ss.SSS").create();
    }

    private void addScriptObjects(Map<String, Object> scriptObjects) {
        if (scriptObjects != null) {
            for (Map.Entry<String, Object> entry : scriptObjects.entrySet()) {
                this.scriptContext.setAttribute(entry.getKey(), entry.getValue(), 100);
            }
        }
    }

    public Map<String, Object> getScriptObjects() {
        return this.scriptObjects;
    }

    private void loadScript(String module) throws Exception {
        this.console.getLogStream().println(String.format("Loading script module: %s", module));
        try {
            String uri = this.symbolLoader.resolveUri(module);
            this.factoryContext.loadedResource(URI.createURI((String)uri));
        }
        catch (Exception exception) {}
        String moduleSource = this.symbolLoader.loadStringResource(module);
        ScriptExecutor s = this.scriptManager.parse(moduleSource, module);
        if (s != null) {
            s.execute(this.scriptContext);
        }
    }

    public void init() throws Exception {
        if (this.onInit != null) {
            try {
                this.onInit.execute(this.scriptContext);
            }
            catch (Exception e) {
                this.errorLog("Failed to run init", e);
                throw new InvocationTargetException(e);
            }
        }
        for (SymbolController controller : this.controllers) {
            controller.init();
        }
    }

    public Properties getProperties() {
        return this.properties;
    }

    protected void addChild(SymbolController controller) {
        this.controllers.add(controller);
    }

    protected void removeChild(SymbolController controller) {
        this.controllers.remove(controller);
    }

    public void dispose() {
        try {
            if (this.onDispose != null) {
                this.onDispose.execute(this.scriptContext);
            }
        }
        catch (Exception e) {
            logger.warn("Failed to dispose", (Throwable)e);
        }
        this.generator.removeListener(this.generatorListener);
        this.generator.dispose();
        if (this.createdConsole != null) {
            ConsolePlugin.getDefault().getConsoleManager().removeConsoles(new IConsole[]{this.createdConsole});
            this.createdConsole = null;
            this.console.dispose();
        }
        if (this.parentController != null) {
            this.parentController.removeChild(this);
        }
        ArrayList<SymbolController> controllers = new ArrayList<SymbolController>(this.controllers);
        for (SymbolController controller : controllers) {
            controller.dispose();
        }
        this.controllers.clear();
        if (this.registrationManager != null) {
            this.registrationManager.dispose();
            this.registrationManager = null;
        }
    }

    public void createProperties(String command, String onCreateProperties, Map<String, String> currentProperties) throws Exception {
        ScriptExecutor executor = this.scriptManager.parse(onCreateProperties, "onCreateProperties");
        if (executor == null) {
            return;
        }
        HashMap<String, Map<String, String>> localProperties = new HashMap<String, Map<String, String>>(1);
        localProperties.put("properties", currentProperties);
        executor.execute(this.scriptContext, localProperties);
    }

    public Object getElement(String name) {
        return this.elements.get(name);
    }

    public Object getElement(Primitive primitive) {
        return this.primitives.get(primitive);
    }

    public void addRawElement(String name, Object element) {
        if (name == null) {
            return;
        }
        this.elements.put(name, element);
    }

    public void addElement(Primitive primitive, Object element) {
        if (primitive == null) {
            return;
        }
        if (primitive.getName() != null) {
            this.elements.put(primitive.getName(), element);
        }
        this.primitives.put(primitive, element);
    }

    public void removeElement(Primitive primitive) {
        if (primitive == null) {
            return;
        }
        this.primitives.remove(primitive);
        this.elements.remove(primitive.getName());
    }

    public void unregisterItem(String name) {
        this.registrationManager.unregisterItem(name);
    }

    public void registerItem(String name, String itemId, String connectionId, boolean ignoreSummary, boolean nullInvalid) {
        this.registrationManager.registerItem(name, itemId, connectionId, ignoreSummary, nullInvalid);
    }

    public void triggerDataUpdate() {
        try {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    SymbolController.this.handleDataUpdate();
                }
            });
        }
        catch (Exception e) {
            StatusManager.getManager().handle(StatusHelper.convertStatus((String)"org.eclipse.scada.vi.ui.draw2d", (Throwable)e));
        }
    }

    public Map<String, DataValue> getRegistrationManagerData() {
        return this.registrationManager.getData();
    }

    public SummaryInformation getSummaryInformation() {
        return new SummaryInformation(this.nameHierarchy, this.registrationManager.getData(), this.collectChildrenData());
    }

    private Collection<SummaryInformation> collectChildrenData() {
        LinkedList<SummaryInformation> result = new LinkedList<SummaryInformation>();
        for (SymbolController controller : this.controllers) {
            result.add(controller.getSummaryInformation());
        }
        return result;
    }

    protected void handleDataUpdate() {
        if (this.registrationManager == null) {
            return;
        }
        Map currentData = this.registrationManager.getData();
        if (currentData == this.lastData) {
            return;
        }
        this.lastData = currentData;
        this.runUpdate(false);
    }

    private void runUpdate(boolean ignoreParents) {
        logger.debug("Running update: {}", this.nameHierarchy);
        try {
            if (this.onUpdate != null) {
                this.onUpdate.execute(this.scriptContext);
            }
        }
        catch (Exception e) {
            StatusManager.getManager().handle(StatusHelper.convertStatus((String)"org.eclipse.scada.vi.ui.draw2d", (Throwable)e), 1);
            this.errorLog("Failed to run update", e);
        }
        this.notifySummaryListeners();
        if (!ignoreParents && this.parentController != null) {
            this.parentController.runUpdate(false);
        }
    }

    protected void notifySummaryListeners() {
        if (this.summaryListeners.isEmpty()) {
            return;
        }
        SummaryInformation info = this.getSummaryInformation();
        logger.debug("notify summary: {}", (Object)info);
        for (SummaryListener listener : this.summaryListeners) {
            logger.debug("notify to: {}", (Object)listener);
            listener.summaryChanged(info);
        }
    }

    public void addSummaryListener(SummaryListener listener) {
        if (this.summaryListeners.add(listener)) {
            listener.summaryChanged(this.getSummaryInformation());
        }
    }

    public void removeSummaryListener(SummaryListener listener) {
        this.summaryListeners.remove(listener);
    }

    public ScriptExecutor createScriptExecutor(String command, String sourceName) throws Exception {
        if (command == null || command.isEmpty()) {
            return null;
        }
        return this.scriptManager.parse(command, sourceName);
    }

    public void execute(ScriptExecutor scriptExecutor, Map<String, Object> scriptObjects) throws Exception {
        if (scriptExecutor == null) {
            return;
        }
        try {
            scriptExecutor.execute(this.scriptContext, scriptObjects);
        }
        catch (Exception e) {
            StatusManager.getManager().handle(StatusHelper.convertStatus((String)"org.eclipse.scada.vi.ui.draw2d", (Throwable)e), 1);
            throw new InvocationTargetException(e);
        }
    }

    public void startWrite(String connectionId, String itemId, Variant value) throws InterruptedException {
        this.registrationManager.startWrite(connectionId, itemId, value, (CallbackHandler)new DisplayCallbackHandler(this.shell, "Confirm", "Confirm write operation"));
    }

    public void startWriteAttributes(String connectionId, String itemId, Map<String, Variant> attributes) throws InterruptedException {
        this.registrationManager.startWriteAttributes(connectionId, itemId, attributes, (CallbackHandler)new DisplayCallbackHandler(this.shell, "Confirm", "Confirm write operation"));
    }

    public void debugLog(String string) {
        this.console.getLogStream().println(string);
    }

    public void errorLog(String string) {
        this.errorLog(string, null);
    }

    public void errorLog(String string, Throwable e) {
        PrintWriter epw = this.console.getErrorPrintWriter();
        epw.println(string);
        if (e != null) {
            e.printStackTrace(epw);
        }
        epw.flush();
    }

    protected SymbolContext getContext() {
        return this.context;
    }

    public SymbolContext getParentContext() {
        if (this.parentController != null) {
            return this.parentController.getContext();
        }
        return null;
    }
}

