/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.ui.views.export.excel.impl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.poi.hpsf.CustomProperties;
import org.apache.poi.hpsf.DocumentSummaryInformation;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFFooter;
import org.apache.poi.hssf.usermodel.HSSFHeader;
import org.apache.poi.hssf.usermodel.HSSFPrintSetup;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.usermodel.HeaderFooter;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.util.CellRangeAddress;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.scada.ae.Event;
import org.eclipse.scada.ae.ui.views.export.excel.Activator;
import org.eclipse.scada.ae.ui.views.export.excel.Cell;
import org.eclipse.scada.ae.ui.views.export.excel.FileTarget;
import org.eclipse.scada.ae.ui.views.export.excel.config.DynamicField;
import org.eclipse.scada.ae.ui.views.export.excel.config.Field;
import org.eclipse.scada.ae.ui.views.export.excel.config.StaticField;
import org.eclipse.scada.ae.ui.views.export.excel.impl.ExcelCell;
import org.eclipse.scada.ae.ui.views.export.excel.impl.Messages;
import org.eclipse.scada.utils.core.runtime.AdapterHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportEventsImpl
implements FileTarget {
    private static final Logger logger = LoggerFactory.getLogger(ExportEventsImpl.class);
    private IStructuredSelection selection;
    private File file;

    public void setSelection(IStructuredSelection selection) {
        this.selection = selection;
    }

    @Override
    public void setFile(File file) {
        this.file = file;
    }

    public void check() {
        if (this.file == null) {
            throw new IllegalStateException(Messages.ExportImpl_ErrorMessage_NoFileSelected);
        }
        if (this.selection == null) {
            throw new IllegalStateException(Messages.ExportImpl_ErrorMessage_NoEventsSelected);
        }
    }

    public IStatus write(IProgressMonitor monitor) {
        if (this.selection == null) {
            return Status.OK_STATUS;
        }
        if (this.file.exists() && !this.file.delete()) {
            return new Status(4, "org.eclipse.scada.ae.ui.views.export.excel", String.format(Messages.ExportImpl_ErrorMessage_FailedToDeleteFile, this.file));
        }
        ArrayList<Event> events = new ArrayList<Event>();
        Iterator i = this.selection.iterator();
        while (i.hasNext()) {
            Event e = (Event)AdapterHelper.adapt(i.next(), Event.class);
            if (e == null) continue;
            events.add(e);
        }
        try {
            return this.storeExcel(this.file, events, this.getFields(events), monitor);
        }
        catch (Exception e) {
            logger.warn(Messages.ExportImpl_ErrorMessage_FailedToExport, (Throwable)e);
            return new Status(4, "org.eclipse.scada.ae.ui.views.export.excel", Messages.ExportImpl_ErrorMessage_FailedToExport, (Throwable)e);
        }
    }

    private List<Field> getFields(Collection<Event> events) {
        HashSet<Field> fields = new HashSet<Field>();
        fields.add(new StaticField("id"){

            @Override
            public void render(Event event, Cell cell) {
                cell.setDataAsText(event.getId().toString());
            }
        });
        fields.add(new StaticField("sourceTimestamp"){

            @Override
            public void render(Event event, Cell cell) {
                cell.setDataAsDate(event.getSourceTimestamp());
            }
        });
        fields.add(new StaticField("entryTimestamp"){

            @Override
            public void render(Event event, Cell cell) {
                cell.setDataAsDate(event.getEntryTimestamp());
            }
        });
        for (Event event : events) {
            for (String key : event.getAttributes().keySet()) {
                fields.add(new DynamicField(key));
            }
        }
        return new ArrayList<Field>(fields);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IStatus storeExcel(File file, List<Event> events, List<Field> columns, IProgressMonitor monitor) throws IOException {
        HSSFWorkbook workbook = new HSSFWorkbook();
        HSSFDataFormat dateFormat = workbook.createDataFormat();
        HSSFCellStyle dateCellStyle = workbook.createCellStyle();
        dateCellStyle.setDataFormat(dateFormat.getFormat("YYYY-MM-DD hh:mm:ss.000"));
        try {
            monitor.beginTask(Messages.ExportImpl_Progress_ExportingEvents, events.size() + 3 + columns.size());
            try {
                monitor.subTask(Messages.ExportImpl_Progress_CreateWorkbook);
                monitor.worked(1);
                HSSFSheet sheet = this.createSheet(events, workbook, columns);
                monitor.worked(1);
                monitor.setTaskName(Messages.ExportImpl_Progress_ExportEvents);
                int i = 0;
                while (i < events.size()) {
                    HSSFRow row = sheet.createRow(i + 1);
                    Event e = events.get(i);
                    int j = 0;
                    while (j < columns.size()) {
                        Field field = columns.get(j);
                        ExcelCell cell = new ExcelCell(row, j, dateCellStyle);
                        field.render(e, cell);
                        ++j;
                    }
                    monitor.worked(1);
                    if (monitor.isCanceled()) {
                        IStatus iStatus = Status.CANCEL_STATUS;
                        return iStatus;
                    }
                    ++i;
                }
                sheet.setRepeatingRows(new CellRangeAddress(0, 1, -1, -1));
                monitor.setTaskName("Auto sizing");
                i = 0;
                while (i < columns.size()) {
                    monitor.subTask(String.format("Auto sizing column: %s", columns.get(i).getHeader()));
                    sheet.autoSizeColumn(i);
                    monitor.worked(1);
                    if (monitor.isCanceled()) {
                        IStatus iStatus = Status.CANCEL_STATUS;
                        return iStatus;
                    }
                    ++i;
                }
                return Status.OK_STATUS;
            }
            finally {
                monitor.subTask(Messages.ExportImpl_Progress_CloseFile);
                if (workbook != null) {
                    this.makeDocInfo(workbook);
                    FileOutputStream stream = new FileOutputStream(file);
                    workbook.write((OutputStream)stream);
                    stream.close();
                }
                monitor.worked(1);
            }
        }
        finally {
            monitor.done();
        }
    }

    private void makeDocInfo(HSSFWorkbook workbook) {
        workbook.createInformationProperties();
        DocumentSummaryInformation dsi = workbook.getDocumentSummaryInformation();
        dsi.setCompany("Eclipse SCADA Project");
        CustomProperties cp = new CustomProperties();
        cp.put("Eclipse SCADA Export Version", Activator.getDefault().getBundle().getVersion().toString());
        dsi.setCustomProperties(cp);
    }

    private HSSFSheet createSheet(List<Event> events, HSSFWorkbook workbook, List<Field> columns) {
        HSSFSheet sheet = workbook.createSheet(Messages.ExportImpl_ExcelSheet_Name);
        HSSFHeader header = sheet.getHeader();
        header.setLeft(Messages.ExportImpl_ExcelSheet_Header);
        header.setRight(String.valueOf(HeaderFooter.date()) + " " + HeaderFooter.time());
        HSSFFooter footer = sheet.getFooter();
        footer.setLeft(String.format(Messages.ExportImpl_ExcelSheet_Footer_1, events.size()));
        footer.setRight(String.valueOf(Messages.ExportImpl_ExcelSheet_Footer_2) + HeaderFooter.page() + Messages.ExportImpl_ExcelSheet_Footer_3 + HeaderFooter.numPages());
        this.makeHeader(columns, sheet);
        HSSFPrintSetup printSetup = sheet.getPrintSetup();
        printSetup.setLandscape(true);
        printSetup.setFitWidth((short)1);
        printSetup.setFitHeight((short)0);
        printSetup.setPaperSize((short)9);
        sheet.setAutoFilter(new CellRangeAddress(0, 0, 0, columns.size() - 1));
        sheet.createFreezePane(0, 1);
        sheet.setFitToPage(true);
        sheet.setAutobreaks(true);
        printSetup.setFooterMargin(0.25);
        sheet.setMargin((short)0, 0.25);
        sheet.setMargin((short)1, 0.25);
        sheet.setMargin((short)2, 0.25);
        sheet.setMargin((short)3, 0.5);
        return sheet;
    }

    private void makeHeader(List<Field> columns, HSSFSheet sheet) {
        HSSFFont font = sheet.getWorkbook().createFont();
        font.setFontName("Arial");
        font.setBoldweight((short)700);
        font.setColor((short)9);
        HSSFCellStyle style = sheet.getWorkbook().createCellStyle();
        style.setFont((Font)font);
        style.setFillForegroundColor((short)8);
        style.setFillPattern((short)1);
        HSSFRow row = sheet.createRow(0);
        int i = 0;
        while (i < columns.size()) {
            Field field = columns.get(i);
            HSSFCell cell = row.createCell(i);
            cell.setCellValue(field.getHeader());
            cell.setCellStyle((CellStyle)style);
            ++i;
        }
    }

    public File getFile() {
        return this.file;
    }
}

