/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.core.ui.connection.provider;

import java.util.Dictionary;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.scada.core.ConnectionInformation;
import org.eclipse.scada.core.connection.provider.ConnectionService;
import org.eclipse.scada.core.ui.connection.creator.ConnectionCreatorHelper;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.scada.core.ui.connection.provider";
    private static Activator plugin;
    private final Set<ServiceRegistration<?>> registrations = new HashSet();
    private final Set<ConnectionService> services = new HashSet<ConnectionService>();

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.createConnections();
    }

    public void stop(BundleContext context) throws Exception {
        this.disposeConnections();
        plugin = null;
        super.stop(context);
    }

    private void createConnections() {
        IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.scada.core.ui.connection.provider.connectionInstance");
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ele = iConfigurationElementArray[n2];
            if ("connectionInstance".equals(ele.getName())) {
                String id = ele.getAttribute("servicePid");
                String uri = ele.getAttribute("uri");
                String autoReconnect = ele.getAttribute("autoReconnect");
                this.createConnection(id, uri, autoReconnect);
            }
            ++n2;
        }
    }

    private void createConnection(String id, String uri, String autoReconnect) {
        try {
            ConnectionService service;
            Integer autoReconnectDelay = null;
            if (autoReconnect != null) {
                autoReconnectDelay = Integer.valueOf(autoReconnect);
            }
            if ((service = ConnectionCreatorHelper.createConnection((ConnectionInformation)ConnectionInformation.fromURI((String)uri), (Integer)autoReconnectDelay, (boolean)false)) != null) {
                if (this.services.add(service)) {
                    service.connect();
                    this.registerService(id, uri, service);
                }
            } else {
                this.getLog().log((IStatus)new Status(2, PLUGIN_ID, String.format("Unable to find connection creator for %s", uri)));
            }
        }
        catch (Exception e) {
            this.getLog().log((IStatus)new Status(4, PLUGIN_ID, "Failed to create connection", (Throwable)e));
        }
    }

    private void registerService(String id, String uri, ConnectionService service) {
        Hashtable<String, String> properties = new Hashtable<String, String>();
        ((Dictionary)properties).put("service.pid", id);
        ((Dictionary)properties).put("connection.uri", uri);
        Class[] clazzes = service.getSupportedInterfaces();
        String[] clazzStr = new String[clazzes.length];
        int i = 0;
        while (i < clazzes.length) {
            clazzStr[i] = clazzes[i].getName();
            ++i;
        }
        ServiceRegistration handle = this.getBundle().getBundleContext().registerService(clazzStr, (Object)service, properties);
        this.registrations.add(handle);
    }

    private void disposeConnections() {
        for (ServiceRegistration<?> reg : this.registrations) {
            reg.unregister();
        }
        for (ConnectionService service : this.services) {
            service.dispose();
        }
        this.services.clear();
        this.registrations.clear();
    }

    public static Activator getDefault() {
        return plugin;
    }
}

