/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ca.ui.editor.forms.common;

import java.net.URL;
import java.util.Map;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.Observables;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.IViewerObservableList;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ObservableValueEditingSupport;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.scada.ca.ui.editor.EditorHelper;
import org.eclipse.scada.ca.ui.editor.forms.common.internal.Activator;
import org.eclipse.scada.ca.ui.editor.input.ConfigurationEditorInput;
import org.eclipse.scada.ui.databinding.observable.KeyPrefixMapObservable;
import org.eclipse.scada.ui.databinding.observable.ObservableMapContentProvider;
import org.eclipse.scada.ui.databinding.observable.StringSplitListObservable;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public class ConfigurationFormToolkit {
    private final FormToolkit toolkit;
    private final boolean toolkitCreated;
    private final DataBindingContext dbc;

    public ConfigurationFormToolkit(Display display) {
        this.toolkit = new FormToolkit(display);
        this.toolkitCreated = true;
        this.dbc = new DataBindingContext();
    }

    public ConfigurationFormToolkit(FormToolkit providedToolkit) {
        this.toolkit = providedToolkit;
        this.toolkitCreated = false;
        this.dbc = new DataBindingContext();
    }

    public DataBindingContext getDataBindingContext() {
        return this.dbc;
    }

    public FormToolkit getFormToolkit() {
        return this.toolkit;
    }

    public void dispose() {
        if (this.toolkitCreated) {
            this.toolkit.dispose();
        }
    }

    public ScrolledForm createScrolledForm(Composite parent, String label) {
        ScrolledForm form = this.toolkit.createScrolledForm(parent);
        form.setText(label);
        this.toolkit.decorateFormHeading(form.getForm());
        return form;
    }

    public Composite createStandardSection(Composite parent, String sectionLabel) {
        return this.createStandardSection(parent, sectionLabel, false);
    }

    public Composite createStandardSection(Composite parent, String sectionLabel, boolean fillVeritcal) {
        Section section = this.toolkit.createSection(parent, sectionLabel != null ? 256 : 4096);
        if (sectionLabel != null) {
            section.setText(sectionLabel);
        }
        Composite client = this.createStandardComposite((Composite)section);
        section.setClient((Control)client);
        client.setLayout((Layout)new GridLayout(3, false));
        section.setLayoutData((Object)new GridData(4, 1, true, fillVeritcal));
        return client;
    }

    public Composite createStandardComposite(Composite parent) {
        Composite client = this.toolkit.createComposite(parent, 0);
        this.toolkit.paintBordersFor(client);
        return client;
    }

    public void createStandardLinkText(Composite parent, final String linkFactory, String attributeName, String label, String textMessage, final ConfigurationEditorInput input, Object valueType) {
        this.toolkit.createLabel(parent, String.valueOf(label) + ":");
        final Text text = this.toolkit.createText(parent, "");
        text.setMessage(textMessage);
        text.setLayoutData((Object)new GridData(4, 1, true, true));
        text.setToolTipText(textMessage);
        IObservableValue value = Observables.observeMapEntry((IObservableMap)input.getDataMap(), (Object)attributeName, (Object)valueType);
        this.dbc.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)text), value);
        Hyperlink link = this.toolkit.createHyperlink(parent, "link", 0);
        link.setLayoutData((Object)new GridData(4, 1, false, false));
        link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                EditorHelper.handleOpen((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (String)input.getConnectionUri(), (String)linkFactory, (String)text.getText());
            }
        });
    }

    public void createStandardText(Composite parent, String attributeName, String label, String textMessage, IObservableMap data, Object valueType) {
        this.createStandardText(parent, attributeName, 4, label, textMessage, data, valueType);
    }

    public void createStandardMultiText(Composite parent, String attributeName, String label, String textMessage, IObservableMap data, Object valueType) {
        this.createStandardText(parent, attributeName, 2, label, textMessage, data, valueType);
    }

    public void createStandardText(Composite parent, String attributeName, int style, String label, String textMessage, IObservableMap data, Object valueType) {
        boolean multi;
        Label labelControl = this.toolkit.createLabel(parent, String.valueOf(label) + ":");
        boolean bl = multi = (style & 2) > 0;
        if (multi) {
            labelControl.setLayoutData((Object)new GridData(4, 4, false, false));
        }
        Text text = this.toolkit.createText(parent, "", style);
        text.setMessage(textMessage);
        GridData gd = new GridData(4, multi ? 4 : 1, true, true);
        gd.horizontalSpan = 2;
        text.setLayoutData((Object)gd);
        text.setToolTipText(textMessage);
        IObservableValue value = Observables.observeMapEntry((IObservableMap)data, (Object)attributeName, String.class);
        if (valueType != null && valueType != String.class) {
            WritableValue conversionValue = new WritableValue(null, valueType);
            this.dbc.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)text), (IObservableValue)conversionValue);
            this.dbc.bindValue((IObservableValue)conversionValue, value);
        } else {
            this.dbc.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)text), value);
        }
    }

    public void createStandardCombo(Composite parent, String attributeName, String label, Object[] items, IObservableMap data, Object valueType) {
        String[] stringItems = new String[items.length];
        int i = 0;
        while (i < items.length) {
            stringItems[i] = items[i].toString();
            ++i;
        }
        this.createStandardCombo(parent, attributeName, label, stringItems, data, valueType);
    }

    public void createStandardCombo(Composite parent, String attributeName, String label, String[] items, IObservableMap data, Object valueType) {
        this.toolkit.createLabel(parent, String.valueOf(label) + ":");
        Combo combo = new Combo(parent, 4);
        combo.setItems(items);
        this.toolkit.adapt((Composite)combo);
        GridData gd = new GridData(4, 1, true, true);
        gd.horizontalSpan = 2;
        combo.setLayoutData((Object)gd);
        IObservableValue value = Observables.observeMapEntry((IObservableMap)data, (Object)attributeName, (Object)valueType);
        this.dbc.bindValue((IObservableValue)WidgetProperties.text().observe((Widget)combo), value);
    }

    public void createStandardCheckbox(Composite parent, String attributeName, String label, IObservableMap data, Object valueType) {
        Button button = this.toolkit.createButton(parent, label, 32);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 3;
        button.setLayoutData((Object)gd);
        IObservableValue value = Observables.observeMapEntry((IObservableMap)data, (Object)attributeName, (Object)valueType);
        this.dbc.bindValue((IObservableValue)WidgetProperties.selection().observe((Widget)button), value);
    }

    public void createInfoSection(ScrolledForm form, ConfigurationEditorInput input) {
        this.createTableSection(form, input, "info.", "Informational Attributes");
    }

    public void createListSection(ScrolledForm form, ConfigurationEditorInput input, String attribute, String label, String delimiter, String pattern) {
        IObservableList list = StringSplitListObservable.observeString((IObservableValue)Observables.observeMapEntry((IObservableMap)input.getDataMap(), (Object)attribute, String.class), (String)delimiter, (String)pattern);
        Section section = this.toolkit.createSection(form.getBody(), 256);
        section.setText(label);
        Composite client = this.toolkit.createComposite((Composite)section, 0);
        section.setClient((Control)client);
        this.toolkit.paintBordersFor(client);
        client.setLayout((Layout)new GridLayout(1, true));
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 2;
        section.setLayoutData((Object)gd);
        ListViewer viewer = new ListViewer(client);
        viewer.setContentProvider((IContentProvider)new ObservableListContentProvider());
        viewer.setInput((Object)list);
        viewer.getControl().setLayoutData((Object)new GridData(1808));
        viewer.setSorter(new ViewerSorter());
    }

    public void createTableSection(ScrolledForm form, ConfigurationEditorInput input, String prefix, String label) {
        IObservableMap map = KeyPrefixMapObservable.observePrefix((IObservableMap)input.getDataMap(), String.class, (String)prefix, (boolean)true);
        Section section = this.toolkit.createSection(form.getBody(), 256);
        section.setText(label);
        Composite client = this.toolkit.createComposite((Composite)section, 0);
        section.setClient((Control)client);
        this.toolkit.paintBordersFor(client);
        client.setLayout((Layout)new GridLayout(1, true));
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 2;
        section.setLayoutData((Object)gd);
        TableViewer viewer = new TableViewer(client);
        TableLayout tableLayout = new TableLayout();
        viewer.getTable().setLayout((Layout)tableLayout);
        TableViewerColumn col = new TableViewerColumn(viewer, 0);
        col.getColumn().setText("Key");
        col.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                cell.setText(String.format("%s", ((Map.Entry)cell.getElement()).getKey()));
            }
        });
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(50, true));
        col = new TableViewerColumn(viewer, 0);
        col.getColumn().setText("Value");
        col.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                cell.setText(String.format("%s", ((Map.Entry)cell.getElement()).getValue()));
            }
        });
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(100, true));
        col.setEditingSupport((EditingSupport)new InlineEditingSupport(map, (ColumnViewer)viewer, this.dbc));
        viewer.getTable().setHeaderVisible(true);
        viewer.setContentProvider((IContentProvider)new ObservableMapContentProvider());
        viewer.setInput((Object)map);
        viewer.getControl().setLayoutData((Object)new GridData(1808));
        viewer.setSorter(new ViewerSorter());
        ToolBarManager tbm = new ToolBarManager();
        tbm.add((IAction)new AddAction(map, form.getShell()));
        tbm.add((IAction)new RemoveAction(map, ViewersObservables.observeMultiSelection((Viewer)viewer)));
        section.setTextClient((Control)tbm.createControl((Composite)section));
    }

    private static class AddAction
    extends Action {
        private final IObservableMap map;
        private final Shell shell;

        public AddAction(IObservableMap map, Shell shell) {
            this.map = map;
            this.shell = shell;
        }

        public String getText() {
            return "+";
        }

        public ImageDescriptor getImageDescriptor() {
            return ImageDescriptor.createFromURL((URL)Activator.getDefault().getBundle().getEntry("/icons/add.gif"));
        }

        public void runWithEvent(Event event) {
            InputDialog dialog = new InputDialog(this.shell, "Add key", "Enter the name of the key to add", "", null);
            if (dialog.open() == 0) {
                this.map.put((Object)dialog.getValue(), (Object)"");
            }
        }
    }

    private static class InlineEditingSupport
    extends ObservableValueEditingSupport {
        private final CellEditor cellEditor;
        private final IObservableMap map;

        public InlineEditingSupport(IObservableMap map, ColumnViewer viewer, DataBindingContext dbc) {
            super(viewer, dbc);
            this.map = map;
            this.cellEditor = new TextCellEditor((Composite)viewer.getControl());
        }

        protected CellEditor getCellEditor(Object element) {
            return this.cellEditor;
        }

        protected IObservableValue doCreateCellEditorObservable(CellEditor cellEditor) {
            return WidgetProperties.text((int)24).observe((Widget)cellEditor.getControl());
        }

        protected IObservableValue doCreateElementObservable(Object element, ViewerCell cell) {
            Object key = ((Map.Entry)element).getKey();
            if (key == null) {
                return null;
            }
            return Observables.observeMapEntry((IObservableMap)this.map, key, String.class);
        }
    }

    private static class RemoveAction
    extends Action {
        private final IObservableMap map;
        private final IViewerObservableList selectedItems;

        public RemoveAction(IObservableMap map, IViewerObservableList selectedItems) {
            this.map = map;
            this.selectedItems = selectedItems;
        }

        public String getText() {
            return "-";
        }

        public ImageDescriptor getImageDescriptor() {
            return ImageDescriptor.createFromURL((URL)Activator.getDefault().getBundle().getEntry("/icons/delete.gif"));
        }

        public void run() {
            for (Object o : this.selectedItems) {
                Map.Entry entry = (Map.Entry)o;
                this.map.remove(entry.getKey());
            }
        }
    }
}

