/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.sec.ui.providers;

import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.concurrent.Future;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.scada.sec.callback.Callback;
import org.eclipse.scada.sec.callback.CallbackHandler;
import org.eclipse.scada.sec.callback.Callbacks;
import org.eclipse.scada.sec.callback.PasswordCallback;
import org.eclipse.scada.sec.ui.providers.Key;
import org.eclipse.scada.ui.utils.status.StatusHelper;
import org.eclipse.scada.utils.beans.AbstractPropertyChange;
import org.eclipse.scada.utils.concurrent.FutureListener;
import org.eclipse.scada.utils.concurrent.NotifyFuture;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class KeyImpl
extends AbstractPropertyChange
implements Key {
    private final String alias;
    private final KeyStore keyStore;
    private java.security.Key key;
    private Certificate certificate;
    private boolean locked = true;

    public KeyImpl(String alias, KeyStore keyStore, String initialPassword) {
        this.alias = alias;
        this.keyStore = keyStore;
        try {
            this.performUnlock(initialPassword);
        }
        catch (Exception exception) {}
    }

    @Override
    public boolean isLocked() {
        return this.locked;
    }

    @Override
    public void dispose() {
        this.key = null;
        this.certificate = null;
    }

    @Override
    public void unlock(CallbackHandler callbackHandler) {
        NotifyFuture future = Callbacks.callback((CallbackHandler)callbackHandler, (Callback)new PasswordCallback("Key password", 0));
        future.addListener((FutureListener)new FutureListener<Callback[]>(){

            public void complete(Future<Callback[]> future) {
                try {
                    KeyImpl.this.performUnlock(((PasswordCallback)future.get()[0]).getPlainPassword());
                }
                catch (Exception e) {
                    ErrorDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Error", (String)"Failed to unlock", (IStatus)StatusHelper.convertStatus((String)"org.eclipse.scada.sec.ui.providers", (Throwable)e));
                }
            }
        });
    }

    protected void performUnlock(String password) throws Exception {
        if (!this.locked) {
            return;
        }
        this.key = this.keyStore.getKey(this.alias, password != null ? password.toCharArray() : null);
        this.certificate = this.keyStore.getCertificate(this.alias);
        this.setLocked(false);
    }

    private void setLocked(boolean locked) {
        this.locked = locked;
        this.firePropertyChange("locked", this.locked, this.locked);
    }

    public String toString() {
        if (this.key != null && this.certificate instanceof X509Certificate) {
            return String.format("%s - %s", this.alias, ((X509Certificate)this.certificate).getSubjectX500Principal());
        }
        if (this.key != null) {
            return String.format("%s - %s - %s", this.alias, this.key.getAlgorithm(), this.key.getFormat());
        }
        return String.format("%s", this.alias);
    }

    @Override
    public boolean isPrivate() {
        return this.key != null;
    }

    @Override
    public java.security.Key getKey() {
        return this.key;
    }

    @Override
    public Certificate getCertificate() {
        return this.certificate;
    }

    @Override
    public String getName() {
        return this.alias;
    }
}

