/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.core.ui.connection.data;

import com.google.common.collect.HashMultimap;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.scada.core.ConnectionInformation;
import org.eclipse.scada.core.client.Connection;
import org.eclipse.scada.core.client.ConnectionState;
import org.eclipse.scada.core.client.ConnectionStateListener;
import org.eclipse.scada.core.connection.provider.ConnectionService;
import org.eclipse.scada.core.ui.connection.Activator;
import org.eclipse.scada.core.ui.connection.ConnectionDescriptor;
import org.eclipse.scada.core.ui.connection.creator.ConnectionCreatorHelper;
import org.eclipse.scada.utils.ExceptionHelper;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class ConnectionManager {
    private final BundleContext context;
    private final HashMultimap<ConnectionDescriptor, EntryWrapper> entryMap;

    public ConnectionManager(BundleContext context) {
        this.context = context;
        this.entryMap = HashMultimap.create();
    }

    public synchronized Entry getConnection(ConnectionDescriptor connectionDescriptor) {
        Set entries = this.entryMap.get((Object)connectionDescriptor);
        if (!entries.isEmpty()) {
            return this.wrapConnection(((EntryWrapper)entries.iterator().next()).getEntry());
        }
        ConnectionService connectionService = ConnectionCreatorHelper.createConnection((ConnectionInformation)connectionDescriptor.getConnectionInformation(), null, (boolean)false);
        if (connectionService == null) {
            return null;
        }
        return this.wrapConnection(this.registerConnection(connectionDescriptor, connectionService));
    }

    protected synchronized Entry wrapConnection(EntryImpl entry) {
        if (entry == null) {
            return null;
        }
        EntryWrapper wrapper = new EntryWrapper(entry);
        this.entryMap.put((Object)entry.getConnectionDescriptor(), (Object)wrapper);
        return wrapper;
    }

    protected synchronized void unwrapConnection(EntryWrapper wrapper) {
        this.entryMap.remove((Object)wrapper.getConnectionDescriptor(), (Object)wrapper);
        if (!this.entryMap.containsKey((Object)wrapper.getConnectionDescriptor())) {
            wrapper.getEntry().dispose();
        }
    }

    private EntryImpl registerConnection(ConnectionDescriptor connectionDescriptor, ConnectionService connectionService) {
        Class[] interfaces = connectionService.getSupportedInterfaces();
        String[] clazzes = new String[interfaces.length];
        int i = 0;
        Class[] classArray = interfaces;
        int n = interfaces.length;
        int n2 = 0;
        while (n2 < n) {
            Class iface = classArray[n2];
            clazzes[i] = iface.getName();
            ++i;
            ++n2;
        }
        Hashtable<String, String> properties = new Hashtable<String, String>();
        ((Dictionary)properties).put("connection.uri", connectionDescriptor.getConnectionInformation().toString());
        if (connectionDescriptor.getServiceId() != null) {
            ((Dictionary)properties).put("service.pid", connectionDescriptor.getServiceId());
        }
        ServiceRegistration serviceRegistration = this.context.registerService(clazzes, (Object)connectionService, properties);
        return new EntryImpl(connectionDescriptor, connectionService, serviceRegistration);
    }

    public void dispose() {
        EntryWrapper[] entryWrapperArray = this.entryMap.values().toArray(new EntryWrapper[0]);
        int n = entryWrapperArray.length;
        int n2 = 0;
        while (n2 < n) {
            EntryWrapper wrapper = entryWrapperArray[n2];
            wrapper.dispose();
            ++n2;
        }
        this.entryMap.clear();
    }

    public static interface Entry {
        public ConnectionDescriptor getConnectionDescriptor();

        public ConnectionService getConnectionService();

        public void dispose();
    }

    public class EntryImpl
    implements Entry,
    ConnectionStateListener {
        private final ConnectionService connectionService;
        private final ConnectionDescriptor connectionDescriptor;
        private final ServiceRegistration<?> serviceRegistration;

        public EntryImpl(ConnectionDescriptor connectionDescriptor, ConnectionService connectionService, ServiceRegistration<?> serviceRegistration) {
            this.connectionDescriptor = connectionDescriptor;
            this.connectionService = connectionService;
            this.serviceRegistration = serviceRegistration;
            connectionService.getConnection().addConnectionStateListener((ConnectionStateListener)this);
        }

        public void stateChange(Connection connection, ConnectionState state, Throwable error) {
            IStatus status = this.makeStatus(connection, state, error);
            Activator.getDefault().getLog().log(status);
            this.showError(status);
        }

        private void showError(final IStatus status) {
            if (!status.matches(4)) {
                return;
            }
            final Display display = PlatformUI.getWorkbench().getDisplay();
            if (!display.isDisposed()) {
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!display.isDisposed()) {
                            ErrorDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Connection error", (String)"Connection failed", (IStatus)status, (int)4);
                        }
                    }
                });
            }
        }

        private IStatus makeStatus(Connection connection, ConnectionState state, Throwable error) {
            int severity;
            String message;
            if (error != null) {
                message = ExceptionHelper.getMessage((Throwable)error);
                severity = 4;
            } else if (state == ConnectionState.CLOSED) {
                message = "Connection closed";
                severity = 2;
            } else {
                message = String.format("State changed: %s", state);
                severity = 1;
            }
            return new Status(severity, "org.eclipse.scada.core.ui.connection", message, error);
        }

        @Override
        public ConnectionDescriptor getConnectionDescriptor() {
            return this.connectionDescriptor;
        }

        @Override
        public ConnectionService getConnectionService() {
            return this.connectionService;
        }

        @Override
        public void dispose() {
            this.connectionService.getConnection().removeConnectionStateListener((ConnectionStateListener)this);
            try {
                this.serviceRegistration.unregister();
            }
            finally {
                this.connectionService.dispose();
            }
        }
    }

    public class EntryWrapper
    implements Entry {
        private final EntryImpl entry;

        public EntryWrapper(EntryImpl entry) {
            this.entry = entry;
        }

        public EntryImpl getEntry() {
            return this.entry;
        }

        @Override
        public ConnectionDescriptor getConnectionDescriptor() {
            return this.entry.getConnectionDescriptor();
        }

        @Override
        public ConnectionService getConnectionService() {
            return this.entry.getConnectionService();
        }

        @Override
        public void dispose() {
            ConnectionManager.this.unwrapConnection(this);
        }
    }
}

