/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.core.ui.connection.views.tree;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.WritableSet;
import org.eclipse.scada.core.ui.connection.ConnectionDescriptor;
import org.eclipse.scada.core.ui.connection.data.ConnectionHolder;
import org.eclipse.scada.core.ui.connection.views.tree.DiscovererListener;

public class ConnectionPoolManager {
    private final WritableSet connectionHolders;
    private final Map<ConnectionDescriptor, Set<DiscovererListener>> descriptorMap = new HashMap<ConnectionDescriptor, Set<DiscovererListener>>();
    private final Map<ConnectionDescriptor, ConnectionHolder> holderMap = new HashMap<ConnectionDescriptor, ConnectionHolder>();

    public ConnectionPoolManager(Realm realm) {
        this.connectionHolders = new WritableSet(realm);
    }

    public void dispose() {
        this.connectionHolders.clear();
        this.connectionHolders.dispose();
    }

    public IObservableSet getAllConnections() {
        return this.connectionHolders;
    }

    public void handleChange(final DiscovererListener discovererListener, final Set<ConnectionDescriptor> additions, final Set<ConnectionDescriptor> removals) {
        this.connectionHolders.getRealm().asyncExec(new Runnable(){

            @Override
            public void run() {
                ConnectionPoolManager.this.applyChange(discovererListener, additions, removals);
            }
        });
    }

    private void applyChange(DiscovererListener discovererListener, Set<ConnectionDescriptor> additions, Set<ConnectionDescriptor> removals) {
        for (ConnectionDescriptor desc : removals) {
            this.remove(discovererListener, desc);
        }
        for (ConnectionDescriptor desc : additions) {
            this.add(discovererListener, desc);
        }
    }

    private void add(DiscovererListener discovererListener, ConnectionDescriptor desc) {
        Set<DiscovererListener> listeners = this.descriptorMap.get(desc);
        if (listeners == null) {
            listeners = new HashSet<DiscovererListener>();
            this.descriptorMap.put(desc, listeners);
            ConnectionHolder holder = new ConnectionHolder(null, desc);
            this.holderMap.put(desc, holder);
            this.connectionHolders.add((Object)holder);
        }
        listeners.add(discovererListener);
    }

    private void remove(DiscovererListener discovererListener, ConnectionDescriptor desc) {
        Set<DiscovererListener> listeners = this.descriptorMap.get(desc);
        if (listeners == null) {
            return;
        }
        listeners.remove(discovererListener);
        if (listeners.isEmpty()) {
            this.descriptorMap.remove(desc);
            ConnectionHolder holder = this.holderMap.remove(desc);
            if (holder != null) {
                this.connectionHolders.remove((Object)holder);
                holder.dispose();
            }
        }
    }
}

