/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.ui.connection.views;

import java.util.Arrays;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.da.core.browser.DataItemEntry;
import org.eclipse.scada.da.core.browser.FolderEntry;
import org.eclipse.scada.da.data.IODirection;
import org.eclipse.scada.ui.databinding.CommonListeningLabelProvider;
import org.eclipse.scada.ui.databinding.StyledViewerLabel;
import org.eclipse.scada.utils.core.runtime.AdapterHelper;

public class ConnectionLabelProvider
extends CommonListeningLabelProvider {
    private final ResourceManager resource = new LocalResourceManager(JFaceResources.getResources());

    public ConnectionLabelProvider() {
        super("org.eclipse.scada.da.ui.connection.provider");
    }

    public void dispose() {
        this.resource.dispose();
        super.dispose();
    }

    public void updateLabel(StyledViewerLabel label, Object element) {
        DataItemEntry dataItemEntry;
        FolderEntry folderEntry = (FolderEntry)AdapterHelper.adapt((Object)element, FolderEntry.class);
        if (folderEntry != null) {
            this.updateFolder(label, folderEntry);
        }
        if ((dataItemEntry = (DataItemEntry)AdapterHelper.adapt((Object)element, DataItemEntry.class)) != null) {
            this.updateItem(label, dataItemEntry);
        }
    }

    private void updateItem(StyledViewerLabel label, DataItemEntry dataItemEntry) {
        String itemName = dataItemEntry.getName();
        if (itemName == null || itemName.length() == 0) {
            itemName = " ";
        }
        label.setText(itemName);
        if (dataItemEntry.getIODirections().containsAll(Arrays.asList(IODirection.INPUT, IODirection.OUTPUT))) {
            label.setImage(this.resource.createImage(ImageDescriptor.createFromFile(ConnectionLabelProvider.class, (String)"icons/item_io.gif")));
        } else if (dataItemEntry.getIODirections().contains(IODirection.INPUT)) {
            label.setImage(this.resource.createImage(ImageDescriptor.createFromFile(ConnectionLabelProvider.class, (String)"icons/item_i.gif")));
        } else if (dataItemEntry.getIODirections().contains(IODirection.OUTPUT)) {
            label.setImage(this.resource.createImage(ImageDescriptor.createFromFile(ConnectionLabelProvider.class, (String)"icons/item_o.gif")));
        } else {
            label.setImage(this.resource.createImage(ImageDescriptor.createFromFile(ConnectionLabelProvider.class, (String)"icons/item.gif")));
        }
    }

    private void updateFolder(StyledViewerLabel label, FolderEntry folderEntry) {
        label.setImage(this.resource.createImage(ImageDescriptor.createFromFile(ConnectionLabelProvider.class, (String)"icons/folder.gif")));
        String folderName = folderEntry.getName();
        if (folderName == null || folderName.length() == 0) {
            folderName = " ";
        }
        label.setText(folderName);
    }

    public String getDescription(Object anElement) {
        Variant value;
        DataItemEntry dataItemEntry = (DataItemEntry)AdapterHelper.adapt((Object)anElement, DataItemEntry.class);
        if (dataItemEntry != null) {
            String itemId = dataItemEntry.getId();
            Variant value2 = (Variant)dataItemEntry.getAttributes().get("description");
            if (value2 != null) {
                return String.format("%s (%s)", itemId, value2.asString(""));
            }
            return itemId;
        }
        FolderEntry folderEntry = (FolderEntry)AdapterHelper.adapt((Object)anElement, FolderEntry.class);
        if (folderEntry != null && (value = (Variant)folderEntry.getAttributes().get("description")) != null) {
            return value.asString(null);
        }
        return super.getDescription(anElement);
    }
}

