/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.core.ui.connection.information;

import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.masterdetail.IObservableFactory;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.databinding.viewers.ObservableSetTreeContentProvider;
import org.eclipse.jface.databinding.viewers.TreeStructureAdvisor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.scada.core.connection.provider.info.ConnectionInformationProvider;
import org.eclipse.scada.core.ui.connection.information.ConnectionInformationList;
import org.eclipse.scada.core.ui.connection.information.ConnectionInformationWrapper;
import org.eclipse.scada.core.ui.connection.information.InformationBeanComparator;
import org.eclipse.scada.core.ui.connection.information.LabelProvider;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.part.ViewPart;

public class InformationViewPart
extends ViewPart {
    private ConnectionInformationList list;
    private TreeViewer viewer;

    public void createPartControl(Composite parent) {
        this.list = new ConnectionInformationList();
        parent.setLayout((Layout)new FillLayout());
        this.viewer = new TreeViewer(parent, 65536);
        this.viewer.getTree().setHeaderVisible(true);
        TableLayout layout = new TableLayout();
        this.viewer.getTree().setLayout((Layout)layout);
        ObservableSetTreeContentProvider contentProvider = new ObservableSetTreeContentProvider(new IObservableFactory(){

            public IObservable createObservable(Object target) {
                if (target instanceof IObservable) {
                    return (IObservable)target;
                }
                if (target instanceof ConnectionInformationProvider) {
                    return new ConnectionInformationWrapper((ConnectionInformationProvider)target);
                }
                return null;
            }
        }, new TreeStructureAdvisor(){});
        TreeViewerColumn col = new TreeViewerColumn(this.viewer, 0);
        col.setLabelProvider((CellLabelProvider)new LabelProvider(contentProvider.getRealizedElements()));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(100));
        col = new TreeViewerColumn(this.viewer, 0);
        col.setLabelProvider((CellLabelProvider)new LabelProvider(contentProvider.getRealizedElements()));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(50));
        col.getColumn().setText("Current");
        col = new TreeViewerColumn(this.viewer, 0);
        col.setLabelProvider((CellLabelProvider)new LabelProvider(contentProvider.getRealizedElements()));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(50));
        col.getColumn().setText("Min");
        col = new TreeViewerColumn(this.viewer, 0);
        col.setLabelProvider((CellLabelProvider)new LabelProvider(contentProvider.getRealizedElements()));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(50));
        col.getColumn().setText("Max");
        this.viewer.setContentProvider((IContentProvider)contentProvider);
        this.viewer.setInput((Object)this.list.getList());
        this.viewer.setComparator((ViewerComparator)new InformationBeanComparator());
        this.getViewSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.hookContextMenu(this.getViewSite());
    }

    private void hookContextMenu(IViewSite viewSite) {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                InformationViewPart.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        viewSite.registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IContributionItem)new Separator("additions"));
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void dispose() {
        this.list.dispose();
        super.dispose();
    }
}

