/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.sec.ui.providers;

import java.io.File;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.util.Enumeration;
import java.util.concurrent.Future;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.scada.sec.callback.Callback;
import org.eclipse.scada.sec.callback.CallbackHandler;
import org.eclipse.scada.sec.callback.CallbackHandlerTranslator;
import org.eclipse.scada.sec.callback.Callbacks;
import org.eclipse.scada.sec.callback.PasswordCallback;
import org.eclipse.scada.sec.ui.providers.Key;
import org.eclipse.scada.sec.ui.providers.KeyImpl;
import org.eclipse.scada.sec.ui.providers.KeyProvider;
import org.eclipse.scada.sec.utils.password.PasswordEncoding;
import org.eclipse.scada.ui.utils.status.StatusHelper;
import org.eclipse.scada.utils.beans.AbstractPropertyChange;
import org.eclipse.scada.utils.concurrent.FutureListener;
import org.eclipse.scada.utils.concurrent.NotifyFuture;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractKeyStoreKeyProvider
extends AbstractPropertyChange
implements KeyProvider {
    private boolean locked = true;
    private final WritableList list;
    private KeyStore keyStore;

    public AbstractKeyStoreKeyProvider(Realm realm) {
        this.list = new WritableList(realm);
    }

    protected void setKeyStore(KeyStore keyStore) {
        this.keyStore = keyStore;
    }

    @Override
    public IObservableList getKeys() {
        return this.list;
    }

    @Override
    public void dispose() {
        for (Object o : this.list) {
            ((Key)o).dispose();
        }
        this.list.dispose();
    }

    @Override
    public boolean isLocked() {
        return this.locked;
    }

    protected void setLocked(boolean locked) {
        this.locked = locked;
        this.firePropertyChange("locked", this.locked, this.locked);
    }

    protected void handleLoadError(Throwable e) {
        ErrorDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Error", (String)"Failed to unlock", (IStatus)StatusHelper.convertStatus((String)"org.eclipse.scada.sec.ui.providers", (Throwable)e));
    }

    protected void load() {
        try {
            this.performLoad();
        }
        catch (Exception e) {
            this.handleLoadError(e);
        }
    }

    protected void load(CallbackHandler callbackHandler) {
        try {
            this.performLoad(callbackHandler);
        }
        catch (Exception e) {
            this.handleLoadError(e);
        }
    }

    protected void load(final File file, CallbackHandler callbackHandler) {
        NotifyFuture future = Callbacks.callback((CallbackHandler)callbackHandler, (Callback)new PasswordCallback("Key store password", 0, new PasswordEncoding[]{PasswordEncoding.PLAIN}));
        future.addListener((FutureListener)new FutureListener<Callback[]>(){

            public void complete(Future<Callback[]> future) {
                try {
                    AbstractKeyStoreKeyProvider.this.performLoad(file, ((PasswordCallback)future.get()[0]).getPlainPassword());
                }
                catch (Exception e) {
                    AbstractKeyStoreKeyProvider.this.handleLoadError(e);
                }
            }
        });
    }

    private void extractKeys(String initPassword) throws KeyStoreException {
        Enumeration<String> en = this.keyStore.aliases();
        while (en.hasMoreElements()) {
            Key key = this.createKey(en.nextElement(), this.keyStore, initPassword);
            if (key == null) continue;
            if (key.isLocked() || key.isPrivate()) {
                this.list.add((Object)key);
                continue;
            }
            key.dispose();
        }
    }

    protected void performLoad(final CallbackHandler callbackHandler) throws Exception {
        this.list.clear();
        this.setLocked(true);
        this.keyStore.load(new KeyStore.LoadStoreParameter(){

            @Override
            public KeyStore.ProtectionParameter getProtectionParameter() {
                return new KeyStore.CallbackHandlerProtection((javax.security.auth.callback.CallbackHandler)new CallbackHandlerTranslator(callbackHandler));
            }
        });
        this.setLocked(false);
        this.extractKeys(null);
    }

    protected void performLoad() throws Exception {
        this.list.clear();
        this.setLocked(true);
        this.keyStore.load(null, null);
        this.setLocked(false);
        this.extractKeys(null);
    }

    protected void performLoad(File file, String password) throws Exception {
        this.list.clear();
        this.setLocked(true);
        try (FileInputStream stream = new FileInputStream(file);){
            this.keyStore.load(stream, password != null ? password.toCharArray() : null);
        }
        this.setLocked(false);
        this.extractKeys(password);
    }

    protected Key createKey(String alias, KeyStore keyStore, String initialPassword) {
        return new KeyImpl(alias, keyStore, initialPassword);
    }
}

