/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ca.ui.jobs;

import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.scada.ca.connection.provider.ConnectionService;
import org.eclipse.scada.ca.data.ConfigurationInformation;
import org.eclipse.scada.ca.ui.Activator;
import org.eclipse.scada.core.ConnectionInformation;
import org.eclipse.scada.core.connection.provider.ConnectionRequest;
import org.eclipse.scada.core.connection.provider.ConnectionRequestTracker;
import org.eclipse.scada.utils.concurrent.NotifyFuture;

public class LoadJob
extends Job {
    private final String connectionUri;
    private final String factoryId;
    private final String configurationId;
    private ConfigurationInformation configuration;
    private final AtomicReference<Thread> runner = new AtomicReference();

    public LoadJob(String connectionUri, String factoryId, String configurationId) {
        super("Loading data");
        this.connectionUri = connectionUri;
        this.factoryId = factoryId;
        this.configurationId = configurationId;
    }

    public ConfigurationInformation getConfiguration() {
        return this.configuration;
    }

    protected void canceling() {
        Thread thread = this.runner.getAndSet(null);
        thread.interrupt();
    }

    protected IStatus run(IProgressMonitor monitor) {
        monitor.beginTask("Loading configuration", 3);
        ConnectionInformation connectionInformation = ConnectionInformation.fromURI((String)this.connectionUri);
        ConnectionRequestTracker tracker = new ConnectionRequestTracker(Activator.getBundleContext(), new ConnectionRequest(null, connectionInformation, Integer.valueOf(10000), true), null);
        try {
            try {
                this.runner.set(Thread.currentThread());
                monitor.worked(1);
                monitor.subTask("Opening tracker");
                tracker.open();
                monitor.subTask("Waiting for service");
                tracker.waitForService(0L);
                ConnectionService service = (ConnectionService)tracker.getService();
                monitor.worked(1);
                monitor.subTask("Retrieving data");
                NotifyFuture task = service.getConnection().getConfiguration(this.factoryId, this.configurationId);
                this.configuration = (ConfigurationInformation)task.get();
                monitor.worked(1);
            }
            catch (InterruptedException interruptedException) {
                IStatus iStatus = Status.CANCEL_STATUS;
                this.runner.set(null);
                monitor.done();
                tracker.close();
                return iStatus;
            }
            catch (Exception e) {
                Status status = new Status(4, "org.eclipse.scada.ca.ui", "Failed to load data", (Throwable)e);
                this.runner.set(null);
                monitor.done();
                tracker.close();
                return status;
            }
        }
        finally {
            this.runner.set(null);
            monitor.done();
            tracker.close();
        }
        return Status.OK_STATUS;
    }
}

