/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ui.chart.view;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.StringUtils;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.scada.ui.chart.configuration.Charts;
import org.eclipse.scada.ui.chart.model.Chart;
import org.eclipse.scada.ui.chart.view.AbstractChartView;
import org.eclipse.scada.ui.utils.status.StatusHelper;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.statushandlers.StatusManager;

public class ChartView
extends AbstractChartView {
    private static final String CHILD_CONFIGURATION = "configuration";
    public static final String VIEW_ID = "org.eclipse.scada.ui.chart.ChartView";
    private Chart configuration;

    @Override
    protected void createChartControl(Composite parent) {
        if (this.configuration == null) {
            this.configuration = Charts.makeDefaultConfiguration();
            this.configuration.setMutable(true);
        }
        this.createView(this.configuration);
    }

    @Override
    public Chart getConfiguration() {
        return this.configuration;
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        if (memento == null) {
            return;
        }
        IMemento child = memento.getChild(CHILD_CONFIGURATION);
        if (child == null) {
            return;
        }
        String data = child.getTextData();
        if (data == null || data.isEmpty()) {
            return;
        }
        try {
            this.configuration = ChartView.load(new ByteArrayInputStream(Base64.decodeBase64((String)data)));
        }
        catch (Exception e) {
            StatusManager.getManager().handle(StatusHelper.convertStatus((String)"org.eclipse.scada.ui.chart.view", (Throwable)e), 1);
        }
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
        if (memento == null) {
            return;
        }
        Resource resource = new XMIResourceFactoryImpl().createResource(null);
        resource.getContents().add((Object)this.configuration);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        HashMap options = new HashMap();
        try {
            resource.save((OutputStream)outputStream, options);
            IMemento child = memento.createChild(CHILD_CONFIGURATION);
            child.putTextData(StringUtils.newStringUtf8((byte[])Base64.encodeBase64((byte[])outputStream.toByteArray(), (boolean)true)));
        }
        catch (Exception e) {
            StatusManager.getManager().handle(StatusHelper.convertStatus((String)"org.eclipse.scada.ui.chart.view", (Throwable)e), 1);
        }
    }
}

