/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.vi.details.swt.widgets;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.swt.CLabel;
import org.eclipse.scada.vi.data.DataValue;
import org.eclipse.scada.vi.data.RegistrationManager;
import org.eclipse.scada.vi.data.SummaryInformation;
import org.eclipse.scada.vi.details.swt.data.DataItemDescriptor;
import org.eclipse.scada.vi.details.swt.widgets.DescriptorLabel;
import org.eclipse.scada.vi.details.swt.widgets.Helper;
import org.eclipse.scada.vi.details.swt.widgets.ReadableComposite;
import org.eclipse.scada.vi.details.swt.widgets.control.BlockControlImage;
import org.eclipse.scada.vi.details.swt.widgets.control.ControlImage;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextComposite
extends ReadableComposite
implements RegistrationManager.Listener {
    private static final Logger logger = LoggerFactory.getLogger(TextComposite.class);
    private final CLabel dataText;
    private final boolean date;
    private Font font;
    private final Map<String, String> map;
    private final ControlImage controlImage;
    private final BlockControlImage blockImage;

    public TextComposite(Composite parent, int style, DataItemDescriptor descriptor, String format, String decimal, boolean isText, String attribute, int width, int height, boolean date, int textHeight, String textMap, String hdConnectionId, String hdItemId, String queryString) {
        super(parent, style, format, decimal, isText, attribute);
        this.date = date;
        this.map = this.stringToMap(textMap);
        if (width == 0) {
            width = 60;
        }
        if (height == 0) {
            height = -1;
        }
        GridLayout layout = new GridLayout(3, false);
        this.setLayout((Layout)layout);
        this.controlImage = new ControlImage(this, this.registrationManager);
        Helper.createTrendButton(this.controlImage, hdConnectionId, hdItemId, queryString);
        this.blockImage = new BlockControlImage(this.controlImage, 0, this.registrationManager);
        this.dataText = new CLabel((Composite)this, 131142);
        if (textHeight != 0) {
            this.font = new Font((Device)this.getDisplay(), new FontData("Arial", textHeight, 0));
            this.dataText.setFont(this.font);
        }
        GridData data = new GridData(4, 0x1000000, false, false);
        data.widthHint = data.minimumWidth = width;
        data.heightHint = data.minimumHeight = height;
        this.dataText.setLayoutData((Object)data);
        this.dataText.setEnabled(true);
        this.dataText.setEllipsis("\u2026");
        this.dataText.setEllipsisAlignment(0x1000008);
        this.dataText.setText("");
        DescriptorLabel label = new DescriptorLabel(this, 0, format, descriptor);
        GridData labelData = new GridData(4, 0x1000000, true, false);
        labelData.minimumWidth = 100;
        label.setLayoutData(labelData);
        if (descriptor != null) {
            this.controlImage.setDetailItem(descriptor.asItem());
            this.blockImage.setBlockItem(descriptor.asItem());
            this.registrationManager.registerItem("value", descriptor.getItemId(), descriptor.getConnectionInformation(), false, false);
        }
    }

    @Override
    protected void handleDispose() {
        if (this.font != null) {
            this.font.dispose();
        }
        super.handleDispose();
    }

    @Override
    protected void updateState(Map<String, DataValue> values, SummaryInformation state) {
        if (this.isDisposed()) {
            logger.trace("No updateView cause widget is disposed");
            return;
        }
        Variant value = null;
        if (this.getAttribute() == null) {
            try {
                value = values.get("value").getValue().getValue();
            }
            catch (NullPointerException e) {
                logger.info("could not get value", (Throwable)e);
                value = Variant.NULL;
            }
        } else {
            try {
                value = (Variant)values.get("value").getValue().getAttributes().get(this.getAttribute());
                if (value == null) {
                    value = values.get("value").getValue().getValue();
                }
            }
            catch (NullPointerException e) {
                logger.info("could not get attribute", (Throwable)e);
                value = Variant.NULL;
            }
        }
        if (value == null) {
            this.dataText.setText(this.getNullReplacementValue() == null ? "" : this.getNullReplacementValue());
        } else if (this.date) {
            this.dataText.setText(this.getDateAsString(values, this.getAttribute()));
        } else if (this.map != null) {
            String convertedText = this.map.get(value.asString(""));
            if (convertedText == null) {
                convertedText = value.asString(this.getNullReplacementValue() == null ? "" : this.getNullReplacementValue());
            }
            this.dataText.setText(String.valueOf(convertedText) + " (" + value.asString("") + ")");
        } else if (value.isDouble()) {
            this.dataText.setText(this.getTextDecimal(values, this.getAttribute()));
        } else {
            this.dataText.setText(value.asString(this.getNullReplacementValue() == null ? "" : this.getNullReplacementValue()));
        }
    }

    private Map<String, String> stringToMap(String string) {
        if (string == null) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        String[] parts = string.split(";");
        int i = 0;
        while (i < parts.length) {
            String[] entry = parts[i].split("=");
            map.put(entry[0], entry[1]);
            logger.debug("Text map: {} {}", (Object)entry[0], (Object)entry[1]);
            ++i;
        }
        return map;
    }
}

