/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.vi.details.swt.widgets;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.vi.data.DataValue;
import org.eclipse.scada.vi.data.SummaryInformation;
import org.eclipse.scada.vi.details.swt.data.DataItemDescriptor;
import org.eclipse.scada.vi.details.swt.dialog.WriteConfirmDialog;
import org.eclipse.scada.vi.details.swt.impl.ViewContext;
import org.eclipse.scada.vi.details.swt.widgets.DescriptorLabel;
import org.eclipse.scada.vi.details.swt.widgets.Messages;
import org.eclipse.scada.vi.details.swt.widgets.WriteableComposite;
import org.eclipse.scada.vi.details.swt.widgets.control.ControlImage;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextInputMultiComposite
extends WriteableComposite {
    private static final Logger logger = LoggerFactory.getLogger(TextInputMultiComposite.class);
    private final Text data;
    private final DataItemDescriptor descriptor;
    private final String attribute;
    private final Button button;
    private final Button buttonClear;
    private final ControlImage controlImage;
    private final ViewContext context;

    public TextInputMultiComposite(ViewContext context, Composite parent, int style, DataItemDescriptor descriptor, String format, String attribute, String hdConnectionId, String hdItemId) {
        super(parent, style, format, null, true, null, null, attribute, hdConnectionId, hdItemId);
        this.context = context;
        this.descriptor = descriptor;
        this.attribute = attribute;
        GridLayoutFactory.fillDefaults().numColumns(5).margins(5, 5).spacing(0, 0).equalWidth(false).applyTo((Composite)this);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this);
        this.controlImage = new ControlImage(this, this.registrationManager);
        new DescriptorLabel(this, 0, format, descriptor);
        this.data = new Text((Composite)this, 18498);
        this.data.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent event) {
                TextInputMultiComposite.this.data.setBackground(Display.getCurrent().getSystemColor(11));
            }
        });
        GridDataFactory.fillDefaults().grab(true, false).hint(160, 50).applyTo((Control)this.data);
        this.button = new Button((Composite)this, 0);
        this.button.setText(Messages.TextInputMultiComposite_send);
        this.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TextInputMultiComposite.this.data.setBackground(Display.getCurrent().getSystemColor(1));
                TextInputMultiComposite.this.triggerCommand(TextInputMultiComposite.this.data.getText());
            }
        });
        this.buttonClear = new Button((Composite)this, 0);
        this.buttonClear.setText(Messages.TextInputMultiComposite_clear);
        this.buttonClear.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TextInputMultiComposite.this.data.setBackground(Display.getCurrent().getSystemColor(1));
                TextInputMultiComposite.this.triggerCommand("");
            }
        });
        if (descriptor != null) {
            this.controlImage.setDetailItem(descriptor.asItem());
            this.registrationManager.registerItem("value", descriptor.getItemId(), descriptor.getConnectionInformation(), false, false);
        }
    }

    protected void triggerCommand(String string) {
        if (!WriteConfirmDialog.create(this.context, this.getShell())) {
            return;
        }
        try {
            this.data.setForeground(Display.getCurrent().getSystemColor(8));
            if (this.attribute == null || this.attribute.equals("")) {
                if (string == null) {
                    this.registrationManager.startWrite(this.descriptor.getConnectionInformation(), this.descriptor.getItemId(), Variant.NULL, this.callbackHandler);
                } else {
                    this.registrationManager.startWrite(this.descriptor.getConnectionInformation(), this.descriptor.getItemId(), Variant.valueOf((Object)string), this.callbackHandler);
                }
            } else {
                HashMap<String, Variant> map = new HashMap<String, Variant>();
                if (string == null) {
                    map.put(this.attribute, Variant.NULL);
                } else {
                    map.put(this.attribute, Variant.valueOf((Object)string));
                }
                this.registrationManager.startWriteAttributes(this.descriptor.getConnectionInformation(), this.descriptor.getItemId(), map, this.callbackHandler);
            }
            this.getShell().setFocus();
        }
        catch (Exception exception) {}
    }

    @Override
    protected void updateState(Map<String, DataValue> values, SummaryInformation state) {
        if (this.isDisposed()) {
            logger.info("No updateView cause widget is disposed");
            return;
        }
        this.setText(this.data, values, this.attribute);
        this.data.setForeground(Display.getCurrent().getSystemColor(2));
        this.data.setEnabled(!state.isBlocked());
    }

    @Override
    protected void triggerCommand() {
        this.triggerCommand(this.data.getText());
    }
}

