/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.vi.details.swt.widgets;

import java.util.Map;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.da.client.DataItemValue;
import org.eclipse.scada.vi.data.DataValue;
import org.eclipse.scada.vi.data.SummaryInformation;
import org.eclipse.scada.vi.details.swt.data.DataItemDescriptor;
import org.eclipse.scada.vi.details.swt.dialog.WriteConfirmDialog;
import org.eclipse.scada.vi.details.swt.impl.ViewContext;
import org.eclipse.scada.vi.details.swt.widgets.DescriptorLabel;
import org.eclipse.scada.vi.details.swt.widgets.Messages;
import org.eclipse.scada.vi.details.swt.widgets.WriteableComposite;
import org.eclipse.scada.vi.details.swt.widgets.control.ControlImage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValueSetComposite
extends WriteableComposite {
    private static final Logger logger = LoggerFactory.getLogger(ValueSetComposite.class);
    private final Composite label;
    private final Text data;
    private final Button setButton;
    private final Button resetButton;
    private final DataItemDescriptor diDescriptorText;
    private final DataItemDescriptor diDescriptorButtonSet;
    private final DataItemDescriptor diDescriptorButtonReset;
    private final ControlImage controlImage;
    private final ViewContext context;

    public ValueSetComposite(ViewContext context, Composite parent, int style, DataItemDescriptor descriptor, DataItemDescriptor setDescriptor, DataItemDescriptor resetDescriptor, String format, Double ceil, Double floor, String decimal, boolean isText, String attribute, String hdConnectionId, String hdItemId) {
        super(parent, style, format, decimal, isText, ceil, floor, attribute, hdConnectionId, hdItemId);
        this.context = context;
        this.diDescriptorButtonReset = resetDescriptor;
        this.diDescriptorButtonSet = setDescriptor;
        this.diDescriptorText = descriptor;
        GridLayoutFactory.fillDefaults().numColumns(4).margins(5, 5).spacing(0, 0).equalWidth(false).applyTo((Composite)this);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this);
        this.label = new DescriptorLabel(this, 0, format, descriptor);
        this.label.setToolTipText(String.valueOf(Messages.ValueSetComposite_valueDescriptor) + descriptor + Messages.ValueSetComposite_setDescriptor + setDescriptor + Messages.ValueSetComposite_resetDescriptor + resetDescriptor);
        this.layout();
        int width = this.label.getBounds().width;
        GridDataFactory.fillDefaults().grab(true, false).span(4, 1).hint(width, 20).applyTo((Control)this.label);
        this.controlImage = new ControlImage(this, this.registrationManager);
        this.data = new Text((Composite)this, 16779268);
        GridDataFactory.fillDefaults().grab(false, false).hint(60, 10).applyTo((Control)this.data);
        this.addDefaultKeyListener(this.data);
        this.setButton = new Button((Composite)this, 0);
        this.setButton.setText(Messages.ValueSetComposite_set);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.setButton);
        this.setButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ValueSetComposite.this.triggerCommand(e);
            }
        });
        this.resetButton = new Button((Composite)this, 0);
        this.resetButton.setText(Messages.ValueSetComposite_reset);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.resetButton);
        this.resetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ValueSetComposite.this.triggerCommand(e);
            }
        });
        this.pack();
        if (descriptor != null) {
            this.controlImage.setDetailItem(descriptor.asItem());
            this.registrationManager.registerItem("value", descriptor.getItemId(), descriptor.getConnectionInformation(), false, false);
        }
    }

    @Override
    protected void makeWarnDialog() {
        super.makeWarnDialog();
        this.setButton.setEnabled(false);
        this.resetButton.setEnabled(false);
    }

    @Override
    protected void triggerCommand() {
        if (!WriteConfirmDialog.create(this.context, this.getShell())) {
            return;
        }
        this.data.setForeground(Display.getCurrent().getSystemColor(8));
        this.setButton.setEnabled(true);
        this.resetButton.setEnabled(true);
        try {
            this.registrationManager.startWrite(this.diDescriptorText.getConnectionInformation(), this.diDescriptorText.getItemId(), Variant.valueOf((Object)this.parseDecimal(this.data.getText())), this.callbackHandler);
        }
        catch (Exception exception) {}
        this.getShell().setFocus();
    }

    private void triggerCommand(SelectionEvent evt) {
        if (!WriteConfirmDialog.create(this.context, this.getShell())) {
            return;
        }
        try {
            if (evt.getSource().equals(this.setButton)) {
                this.registrationManager.startWrite(this.diDescriptorButtonSet.getConnectionInformation(), this.diDescriptorButtonSet.getItemId(), Variant.TRUE, this.callbackHandler);
            } else if (evt.getSource().equals(this.resetButton)) {
                this.registrationManager.startWrite(this.diDescriptorButtonReset.getConnectionInformation(), this.diDescriptorButtonReset.getItemId(), Variant.TRUE, this.callbackHandler);
            } else {
                logger.warn("Missing click item for write operation");
            }
        }
        catch (Exception exception) {}
    }

    @Override
    protected void updateState(Map<String, DataValue> values, SummaryInformation state) {
        if (this.isDisposed()) {
            logger.info("No updateView cause widget is disposed");
            return;
        }
        DataItemValue value = values.get("value").getValue();
        this.setCeil(value);
        this.setFloor(value);
        this.setTextDecimal(this.data, value);
        this.data.setForeground(Display.getCurrent().getSystemColor(2));
    }
}

