/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.ui.views.views;

import com.google.common.base.Enums;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.databinding.observable.set.ISetChangeListener;
import org.eclipse.core.databinding.observable.set.SetChangeEvent;
import org.eclipse.core.databinding.observable.set.WritableSet;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.databinding.viewers.ObservableSetContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.scada.ae.Event;
import org.eclipse.scada.ae.ui.views.Settings;
import org.eclipse.scada.ae.ui.views.config.ColumnLabelProviderInformation;
import org.eclipse.scada.ae.ui.views.dialog.EventDetailsDialog;
import org.eclipse.scada.ae.ui.views.dialog.SearchType;
import org.eclipse.scada.ae.ui.views.filter.EventViewerFilter;
import org.eclipse.scada.ae.ui.views.model.DecoratedEvent;
import org.eclipse.scada.ae.ui.views.views.ColumnProperties;
import org.eclipse.scada.ae.ui.views.views.EventTableColumn;
import org.eclipse.scada.ae.ui.views.views.EventTableSorter;
import org.eclipse.scada.ae.ui.views.views.LabelProviderSupport;
import org.eclipse.scada.ui.utils.SelectionHelper;
import org.eclipse.scada.utils.lang.Pair;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IViewSite;

public class EventViewTable
extends Composite {
    private static final String COLUMN_KEY = "org.eclipse.scada.ae.ui.views.views.EventViewTable.column.key";
    private final WritableSet events;
    private volatile boolean scrollLock = false;
    private Pair<SearchType, String> filter;
    private final TableViewer tableViewer;
    private final LabelProviderSupport labelProviderSupport;
    private final List<ColumnLabelProviderInformation> columnInformations;

    public EventViewTable(Composite parent, IViewSite viewSite, int style, WritableSet events, List<ColumnProperties> columnSettings) {
        this(parent, viewSite, style, events, columnSettings, null);
    }

    public EventViewTable(Composite parent, IViewSite viewSite, int style, WritableSet events, List<ColumnProperties> columnSettings, List<ColumnLabelProviderInformation> columnInformations) {
        super(parent, style);
        this.events = events;
        this.columnInformations = EventViewTable.makeColumnInformations(columnInformations);
        this.labelProviderSupport = new LabelProviderSupport(Settings.getTimeZone());
        FillLayout layout = new FillLayout();
        this.setLayout((Layout)layout);
        this.tableViewer = new TableViewer((Composite)this, 66306);
        this.createColumns(this.tableViewer);
        this.applyColumSettings(columnSettings);
        this.tableViewer.getTable().setHeaderVisible(true);
        this.tableViewer.getTable().setLinesVisible(true);
        this.tableViewer.setUseHashlookup(true);
        this.tableViewer.setSorter((ViewerSorter)new EventTableSorter(EventTableColumn.reservedColumnSourceTimestamp, 1024));
        this.tableViewer.getTable().setSortDirection(1024);
        this.hookContextMenu(this.tableViewer.getControl(), (ISelectionProvider)this.tableViewer, viewSite);
        this.tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                EventViewTable.this.handleDoubleClick(event.getSelection());
            }
        });
        viewSite.setSelectionProvider((ISelectionProvider)this.tableViewer);
        ObservableSetContentProvider contentProvider = new ObservableSetContentProvider();
        this.tableViewer.setContentProvider((IContentProvider)contentProvider);
        this.tableViewer.setInput((Object)this.events);
        contentProvider.getRealizedElements().addSetChangeListener(new ISetChangeListener(){

            public void handleSetChange(SetChangeEvent event) {
                if (!EventViewTable.this.scrollLock) {
                    EventViewTable.this.tableViewer.getTable().setTopIndex(0);
                }
            }
        });
    }

    protected void handleDoubleClick(ISelection selection) {
        DecoratedEvent event = (DecoratedEvent)SelectionHelper.first((ISelection)selection, DecoratedEvent.class);
        if (event == null || event.getEvent() == null) {
            return;
        }
        new EventDetailsDialog(this.getShell()).open(event.getEvent());
    }

    private static List<ColumnLabelProviderInformation> makeColumnInformations(List<ColumnLabelProviderInformation> columnInformations) {
        if (columnInformations != null) {
            return columnInformations;
        }
        LinkedList<ColumnLabelProviderInformation> result = new LinkedList<ColumnLabelProviderInformation>();
        result.add(new ColumnLabelProviderInformation("ID", "id", false, 100, null));
        result.add(new ColumnLabelProviderInformation("Source Timestamp", "sourceTimestamp", true, 100, null));
        Event.Fields[] fieldsArray = Event.Fields.values();
        int n = fieldsArray.length;
        int n2 = 0;
        while (n2 < n) {
            Event.Fields field = fieldsArray[n2];
            if (Enums.getField((Enum)field).getAnnotation(Deprecated.class) == null) {
                HashMap<String, String> parameters = new HashMap<String, String>(1);
                parameters.put("key", field.getName());
                result.add(new ColumnLabelProviderInformation(field.getName(), "variant", false, 100, parameters));
            }
            ++n2;
        }
        int i = 0;
        while (i < 6) {
            HashMap<String, String> parameters = new HashMap<String, String>(1);
            parameters.put("key", String.format("level.%s", i));
            String label = String.format("Level %s", i);
            result.add(new ColumnLabelProviderInformation(label, "variant", false, 100, parameters));
            ++i;
        }
        result.add(new ColumnLabelProviderInformation("Entry Timestamp", "entryTimestamp", true, 100, null));
        return result;
    }

    public void dispose() {
        super.dispose();
        this.labelProviderSupport.dispose();
    }

    protected void hookContextMenu(Control control, ISelectionProvider selectionProvider, IViewSite viewSite) {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                EventViewTable.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(control);
        control.setMenu(menu);
        viewSite.registerContextMenu(menuMgr, selectionProvider);
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IContributionItem)new Separator("additions"));
    }

    public TableViewer getTableViewer() {
        return this.tableViewer;
    }

    private void applyColumSettings(List<ColumnProperties> columnSettings) {
        if (columnSettings == null) {
            return;
        }
        int[] colOrder = this.tableViewer.getTable().getColumnOrder();
        int i = 0;
        for (ColumnProperties p : columnSettings) {
            if (i >= colOrder.length) break;
            colOrder[i] = p.getNo();
            ++i;
        }
        this.tableViewer.getTable().setColumnOrder(colOrder);
        i = 0;
        for (ColumnProperties p : columnSettings) {
            if (i >= this.tableViewer.getTable().getColumnCount()) break;
            TableColumn col = this.tableViewer.getTable().getColumn(i);
            col.setWidth(p.getWidth());
            ++i;
        }
    }

    public void clear() {
        this.events.clear();
    }

    private void createColumns(TableViewer table) {
        SortListener sortListener = new SortListener(table);
        for (ColumnLabelProviderInformation columnInformation : this.columnInformations) {
            CellLabelProvider labelProvider;
            TableViewerColumn fieldColumn = new TableViewerColumn(table, 0);
            fieldColumn.getColumn().setText(columnInformation.getLabel());
            fieldColumn.getColumn().setWidth(columnInformation.getInitialSize());
            fieldColumn.getColumn().setResizable(true);
            fieldColumn.getColumn().setMoveable(true);
            if (columnInformation.isSortable()) {
                fieldColumn.getColumn().addSelectionListener((SelectionListener)sortListener);
            }
            if ((labelProvider = columnInformation.createLabelProvider(this.labelProviderSupport)) != null) {
                fieldColumn.setLabelProvider(labelProvider);
                continue;
            }
            fieldColumn.setLabelProvider((CellLabelProvider)new StyledCellLabelProvider(){});
        }
    }

    public List<DecoratedEvent> selectedEvents() {
        if (this.tableViewer.getTable().getSelectionCount() == 0) {
            return new ArrayList<DecoratedEvent>();
        }
        ArrayList<DecoratedEvent> result = new ArrayList<DecoratedEvent>();
        TableItem[] tableItemArray = this.tableViewer.getTable().getSelection();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem row = tableItemArray[n2];
            if (row.getData() instanceof DecoratedEvent) {
                result.add((DecoratedEvent)row.getData());
            }
            ++n2;
        }
        return result;
    }

    public void removeFilter() {
        this.filter = null;
        this.tableViewer.resetFilters();
    }

    public void setFilter(Pair<SearchType, String> filter) {
        if (filter == null) {
            return;
        }
        if (filter.equals(this.filter)) {
            return;
        }
        this.tableViewer.resetFilters();
        this.filter = filter;
        this.tableViewer.addFilter((ViewerFilter)new EventViewerFilter((String)filter.second));
    }

    public Pair<SearchType, String> getFilter() {
        return this.filter;
    }

    public List<ColumnProperties> getColumnSettings() {
        ArrayList<ColumnProperties> result = new ArrayList<ColumnProperties>();
        int i = 0;
        int[] order = this.tableViewer.getTable().getColumnOrder();
        TableColumn[] tableColumnArray = this.tableViewer.getTable().getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn col = tableColumnArray[n2];
            result.add(new ColumnProperties(order[i], col.getWidth()));
            ++i;
            ++n2;
        }
        return result;
    }

    public void setScrollLock(boolean scrollLock) {
        this.scrollLock = scrollLock;
    }

    public boolean isScrollLock() {
        return this.scrollLock;
    }

    private static class SortListener
    extends SelectionAdapter {
        private final TableViewer tableViewer;

        public SortListener(TableViewer tableViewer) {
            this.tableViewer = tableViewer;
        }

        public void widgetSelected(SelectionEvent e) {
            Table table = this.tableViewer.getTable();
            TableColumn newColumn = (TableColumn)e.widget;
            TableColumn currentColumn = table.getSortColumn();
            EventTableColumn column = (EventTableColumn)newColumn.getData(EventViewTable.COLUMN_KEY);
            if (column == EventTableColumn.reservedColumnSourceTimestamp || column == EventTableColumn.reservedColumnEntryTimestamp) {
                int currentDir = table.getSortDirection();
                int newDir = 128;
                if (newColumn == currentColumn) {
                    newDir = currentDir == 128 ? 1024 : 128;
                } else {
                    table.setSortColumn(newColumn);
                }
                table.setSortDirection(newDir);
                this.tableViewer.setSorter((ViewerSorter)new EventTableSorter(column, newDir));
            }
        }
    }
}

