/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.ui.views.views;

import java.util.TimeZone;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.jface.databinding.viewers.ObservableMapLabelProvider;
import org.eclipse.scada.ae.data.Severity;
import org.eclipse.scada.ae.ui.views.model.DecoratedMonitor;
import org.eclipse.scada.ae.ui.views.model.MonitorData;
import org.eclipse.scada.ae.ui.views.views.LabelProviderSupport;
import org.eclipse.scada.ae.ui.views.views.Messages;
import org.eclipse.scada.core.Variant;
import org.eclipse.swt.graphics.Image;

public class MonitorTableLabelProvider
extends ObservableMapLabelProvider {
    private final LabelProviderSupport labelProviderSupport;

    public MonitorTableLabelProvider(IObservableMap attributeMap, TimeZone timeZone) {
        super(attributeMap);
        this.labelProviderSupport = new LabelProviderSupport(timeZone);
    }

    public MonitorTableLabelProvider(IObservableMap[] attributeMaps, TimeZone timeZone) {
        super(attributeMaps);
        this.labelProviderSupport = new LabelProviderSupport(timeZone);
    }

    public void dispose() {
        super.dispose();
        this.labelProviderSupport.dispose();
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (!(element instanceof DecoratedMonitor)) {
            return null;
        }
        MonitorData monitor = ((DecoratedMonitor)element).getMonitor();
        if (columnIndex == 1) {
            switch (monitor.getStatus()) {
                case INACTIVE: {
                    break;
                }
                case UNSAFE: {
                    return this.labelProviderSupport.getDisconnectedImage();
                }
                case OK: {
                    return this.labelProviderSupport.getOkImage();
                }
                case NOT_OK: 
                case NOT_OK_AKN: {
                    if (monitor.getSeverity() == Severity.WARNING) {
                        return this.labelProviderSupport.getWarningImage();
                    }
                    return this.labelProviderSupport.getAlarmImage();
                }
                case NOT_AKN: {
                    return this.labelProviderSupport.getAckImage();
                }
                case NOT_OK_NOT_AKN: {
                    return this.labelProviderSupport.getAckImage();
                }
            }
            return this.labelProviderSupport.getEmptyImage();
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        if (!(element instanceof DecoratedMonitor)) {
            return Messages.MonitorTableLabelProvider_EmptyString;
        }
        MonitorData monitor = ((DecoratedMonitor)element).getMonitor();
        switch (columnIndex) {
            case 0: {
                return monitor.getId().toString();
            }
            case 1: {
                return monitor.getStatus().toString();
            }
            case 2: {
                return this.labelProviderSupport.formatDate(monitor.getLastFailTimestamp());
            }
            case 3: {
                return this.labelProviderSupport.toLabel(monitor.getLastFailValue());
            }
            case 4: {
                return this.labelProviderSupport.toLabel(monitor.getValue());
            }
            case 5: {
                return monitor.getLastAknUser();
            }
            case 6: {
                return this.labelProviderSupport.formatDate(monitor.getLastAknTimestamp());
            }
            case 7: {
                return this.labelProviderSupport.toLabel((Variant)monitor.getAttributes().get("item"));
            }
            case 8: {
                return this.labelProviderSupport.toLabel((Variant)monitor.getAttributes().get("itemDescription"));
            }
            case 9: {
                return this.labelProviderSupport.toLabel((Variant)monitor.getAttributes().get("message"));
            }
            case 10: {
                return this.labelProviderSupport.formatDate(monitor.getStatusTimestamp());
            }
            case 11: {
                return monitor.getSeverity() == null ? "" : monitor.getSeverity().name();
            }
        }
        return Messages.MonitorTableLabelProvider_EmptyString;
    }
}

