/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.sec.ui.providers.pkcs12;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.scada.sec.ui.providers.KeyProvider;
import org.eclipse.scada.sec.ui.providers.KeyProviderFactory;
import org.eclipse.scada.sec.ui.providers.pkcs12.PKCS12KeyProvider;
import org.eclipse.scada.ui.utils.status.StatusHelper;
import org.eclipse.ui.statushandlers.StatusManager;

public class FactoryImpl
implements KeyProviderFactory {
    private final Set<String> files = new HashSet<String>();
    private Realm realm;
    private WritableList list;
    private final Preferences prefs = Preferences.userNodeForPackage(FactoryImpl.class).node("files");

    public FactoryImpl() {
        try {
            String[] stringArray = this.prefs.childrenNames();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String child = stringArray[n2];
                Preferences childNode = this.prefs.node(child);
                String fileName = childNode.get("file", null);
                if (fileName != null) {
                    this.files.add(fileName);
                }
                ++n2;
            }
        }
        catch (BackingStoreException e) {
            StatusManager.getManager().handle(StatusHelper.convertStatus((String)"org.eclipse.scada.sec.ui.providers.pkcs12", (Throwable)e));
        }
    }

    public void addFile(String fileName) throws Exception {
        File file = new File(fileName).getAbsoluteFile();
        Preferences newChild = this.prefs.node(UUID.randomUUID().toString());
        newChild.put("file", file.toString());
        newChild.flush();
        this.files.add(fileName);
        this.loadFile(fileName);
    }

    public void remove(KeyProvider keyProvider) throws Exception {
        if (!(keyProvider instanceof PKCS12KeyProvider)) {
            return;
        }
        if (!this.list.remove((Object)keyProvider)) {
            return;
        }
        File file = ((PKCS12KeyProvider)keyProvider).getFile();
        keyProvider.dispose();
        this.removeFile(file.getAbsoluteFile());
    }

    private void removeFile(File file) throws Exception {
        String[] stringArray = this.prefs.childrenNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String childName = stringArray[n2];
            Preferences child = this.prefs.node(childName);
            String fileName = new File(child.get("file", null)).getAbsolutePath();
            if (file.getAbsolutePath().equals(fileName)) {
                child.removeNode();
            }
            ++n2;
        }
        this.prefs.flush();
    }

    public void init(Realm realm) {
        this.realm = realm;
        this.list = new WritableList();
        for (String fileName : this.files) {
            this.loadFile(fileName);
        }
    }

    private void loadFile(String fileName) {
        try {
            this.list.add((Object)new PKCS12KeyProvider(this.realm, new File(fileName)));
        }
        catch (Exception e) {
            StatusManager.getManager().handle(StatusHelper.convertStatus((String)"org.eclipse.scada.sec.ui.providers.pkcs12", (Throwable)e));
        }
    }

    public void dispose() {
        for (Object o : this.list) {
            ((PKCS12KeyProvider)((Object)o)).dispose();
        }
        this.list.dispose();
    }

    public String toString() {
        return "PKCS12";
    }

    public IObservableList getKeyProviders() {
        return this.list;
    }
}

