/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.ui.summary.explorer;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.masterdetail.IObservableFactory;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.viewers.ObservableSetTreeContentProvider;
import org.eclipse.jface.databinding.viewers.TreeStructureAdvisor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.scada.core.ui.styles.StateInformation;
import org.eclipse.scada.da.connection.provider.ConnectionService;
import org.eclipse.scada.da.core.Location;
import org.eclipse.scada.da.ui.summary.explorer.FactoryImpl;
import org.eclipse.scada.da.ui.summary.explorer.NameLabelProviderImpl;
import org.eclipse.scada.da.ui.summary.explorer.StateLabelProviderImpl;
import org.eclipse.scada.da.ui.summary.explorer.TreeNode;
import org.eclipse.scada.ui.databinding.ListeningStyledCellLabelProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.part.ViewPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SummaryExplorerViewPart
extends ViewPart {
    static final Logger logger = LoggerFactory.getLogger(SummaryExplorerViewPart.class);
    public static final String VIEW_ID = "org.eclipse.scada.da.ui.summary.explorer.view";
    private ConnectionService connectionService;
    private TreeViewer viewer;
    private TreeNode input;
    private Realm realm;
    private final List<ListeningStyledCellLabelProvider> labelProviders = new LinkedList<ListeningStyledCellLabelProvider>();

    public void createPartControl(Composite parent) {
        this.realm = SWTObservables.getRealm((Display)parent.getDisplay());
        this.viewer = new TreeViewer(parent, 65536);
        ObservableSetTreeContentProvider contentProvider = new ObservableSetTreeContentProvider((IObservableFactory)new FactoryImpl(), new TreeStructureAdvisor(){});
        this.viewer.setContentProvider((IContentProvider)contentProvider);
        this.viewer.getTree().setHeaderVisible(true);
        TableLayout layout = new TableLayout();
        TreeViewerColumn col = new TreeViewerColumn(this.viewer, 0);
        NameLabelProviderImpl labelProvider = new NameLabelProviderImpl(contentProvider.getRealizedElements());
        col.setLabelProvider((CellLabelProvider)labelProvider);
        col.getColumn().setText("Name");
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(100));
        this.labelProviders.add(labelProvider);
        StateInformation.State[] stateArray = StateInformation.State.values();
        int n = stateArray.length;
        int n2 = 0;
        while (n2 < n) {
            StateInformation.State state = stateArray[n2];
            TreeViewerColumn col2 = new TreeViewerColumn(this.viewer, 0);
            StateLabelProviderImpl labelProvider2 = new StateLabelProviderImpl(contentProvider.getRealizedElements(), state);
            col2.setLabelProvider((CellLabelProvider)labelProvider2);
            col2.getColumn().setText(state.name());
            layout.addColumnData((ColumnLayoutData)new ColumnWeightData(25));
            this.labelProviders.add(labelProvider2);
            ++n2;
        }
        this.viewer.getTree().setLayout((Layout)layout);
    }

    public void setConnectionService(ConnectionService connectionService) {
        if (this.input != null) {
            this.viewer.setInput(null);
            this.input.dispose();
        }
        this.connectionService = connectionService;
        if (this.connectionService != null) {
            this.input = new TreeNode(this.realm, this.connectionService, Location.ROOT, null);
            this.viewer.setInput((Object)this.input);
        }
    }

    public void dispose() {
        for (ListeningStyledCellLabelProvider labelProvider : this.labelProviders) {
            labelProvider.dispose();
        }
        if (this.input != null) {
            this.input.dispose();
            this.input = null;
        }
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }
}

