/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.vi.ui.draw2d;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import javax.script.ScriptContext;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;

public class ConsoleContext {
    private PrintWriter errorPrintWriter;
    private MessageConsoleStream logStream;
    private MessageConsoleStream writerStream;

    public ConsoleContext(MessageConsole messageConsole) {
        this.writerStream = messageConsole.newMessageStream();
        MessageConsoleStream errorStream = messageConsole.newMessageStream();
        errorStream.setColor(Display.getDefault().getSystemColor(3));
        this.errorPrintWriter = new PrintWriter(new OutputStreamWriter((OutputStream)errorStream));
        this.logStream = messageConsole.newMessageStream();
        this.logStream.setColor(Display.getDefault().getSystemColor(15));
    }

    public void applyTo(ScriptContext scriptContext) {
        scriptContext.setWriter(new PrintWriter(new OutputStreamWriter((OutputStream)this.writerStream)));
        scriptContext.setErrorWriter(this.errorPrintWriter);
    }

    public MessageConsoleStream getLogStream() {
        return this.logStream;
    }

    public PrintWriter getErrorPrintWriter() {
        return this.errorPrintWriter;
    }

    public void dispose() {
        if (this.writerStream != null) {
            try {
                this.writerStream.close();
            }
            catch (IOException iOException) {}
            this.writerStream = null;
        }
        if (this.errorPrintWriter != null) {
            try {
                this.errorPrintWriter.close();
            }
            catch (Exception exception) {}
            this.errorPrintWriter = null;
        }
        if (this.logStream != null) {
            try {
                this.logStream.close();
            }
            catch (IOException iOException) {}
            this.logStream = null;
        }
    }
}

