/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.vi.ui.draw2d;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.draw2d.ConnectionLayer;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Layer;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.ManhattanConnectionRouter;
import org.eclipse.draw2d.ScalableLayeredPane;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.PrecisionDimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.scada.ui.utils.status.StatusHelper;
import org.eclipse.scada.vi.data.SummaryInformation;
import org.eclipse.scada.vi.data.SummaryListener;
import org.eclipse.scada.vi.data.SummaryProvider;
import org.eclipse.scada.vi.model.Connection;
import org.eclipse.scada.vi.model.Primitive;
import org.eclipse.scada.vi.model.Symbol;
import org.eclipse.scada.vi.ui.draw2d.Activator;
import org.eclipse.scada.vi.ui.draw2d.BasicViewElementFactory;
import org.eclipse.scada.vi.ui.draw2d.Controller;
import org.eclipse.scada.vi.ui.draw2d.FactoryContext;
import org.eclipse.scada.vi.ui.draw2d.Helper;
import org.eclipse.scada.vi.ui.draw2d.SymbolController;
import org.eclipse.scada.vi.ui.draw2d.loader.StaticSymbolLoader;
import org.eclipse.scada.vi.ui.draw2d.loader.SymbolLoader;
import org.eclipse.scada.vi.ui.draw2d.loader.XMISymbolLoader;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.statushandlers.StatusManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.profiler.Profiler;

public class VisualInterfaceViewer
extends Composite
implements SummaryProvider {
    private static final Logger logger = LoggerFactory.getLogger(VisualInterfaceViewer.class);
    private final BasicViewElementFactory factory;
    private final FigureCanvas canvas;
    private final LocalResourceManager manager;
    private SymbolController controller;
    private final Map<String, Object> scriptObjects;
    private final Map<String, String> initialProperties;
    private Boolean zooming;
    private ScalableLayeredPane pane;
    private IFigure figure;
    private Symbol symbol;
    private Layer layer;
    private ConnectionLayer connectionLayer;
    private final Set<URI> loadedResources = new HashSet<URI>();
    private final FactoryContext factoryContext;

    public VisualInterfaceViewer(Composite parent, int style, java.net.URI uri, Map<String, Object> scriptObjects, Map<String, String> properties) {
        this(parent, style, uri.toString(), scriptObjects, properties);
    }

    public VisualInterfaceViewer(Composite parent, int style, String uri, Map<String, Object> scriptObjects, Map<String, String> properties) {
        this(parent, style, new XMISymbolLoader(uri), scriptObjects, properties);
    }

    public VisualInterfaceViewer(Composite parent, int style, Symbol symbol, Map<String, Object> scriptObjects, Map<String, String> properties) {
        this(parent, style, new StaticSymbolLoader(symbol), scriptObjects, properties);
    }

    public VisualInterfaceViewer(Composite parent, int style, SymbolLoader symbolLoader, Map<String, Object> scriptObjects, Map<String, String> properties) {
        this(parent, style, symbolLoader, scriptObjects, properties, null);
    }

    public VisualInterfaceViewer(Composite parent, int style, SymbolLoader symbolLoader, Map<String, Object> scriptObjects, Map<String, String> properties, FactoryContext factoryContext) {
        super(parent, style);
        Profiler p = new Profiler("VisualInterfaceViewer");
        p.start("init");
        this.initialProperties = properties == null ? Collections.emptyMap() : properties;
        this.scriptObjects = scriptObjects;
        this.factoryContext = factoryContext;
        p.start("rm");
        this.manager = new LocalResourceManager(JFaceResources.getResources());
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                VisualInterfaceViewer.this.internalDispose();
            }
        });
        this.setLayout((Layout)new FillLayout());
        this.canvas = this.createCanvas();
        this.setZooming(null);
        p.start("new factory");
        this.factory = new BasicViewElementFactory(this.canvas, (ResourceManager)this.manager, symbolLoader, this.factoryContext);
        try {
            p.start("create pane");
            this.pane = this.createPane();
            this.layer = new Layer();
            this.connectionLayer = new ConnectionLayer();
            this.connectionLayer.setConnectionRouter((ConnectionRouter)new ManhattanConnectionRouter());
            this.layer.setLayoutManager((LayoutManager)new StackLayout());
            this.pane.add((IFigure)this.connectionLayer);
            this.pane.add((IFigure)this.layer);
            p.start("load");
            this.symbol = symbolLoader.loadSymbol();
            p.start("create");
            this.create(symbolLoader);
            p.start("apply");
            this.applyColor(this.symbol);
            this.applyImage(this.symbol, symbolLoader);
        }
        catch (Exception e) {
            logger.warn("Failed to create view", (Throwable)e);
            StatusManager.getManager().handle(StatusHelper.convertStatus((String)"org.eclipse.scada.vi.ui.draw2d", (Throwable)e));
            this.canvas.setContents(Helper.createErrorFigure(e));
        }
        p.stop().print();
    }

    public Set<URI> getResources() {
        return this.loadedResources;
    }

    private ScalableLayeredPane createPane() {
        return new ScalableLayeredPane();
    }

    public boolean isZooming() {
        if (this.zooming == null) {
            return Activator.getDefault().getPreferenceStore().getBoolean("default.zooming");
        }
        return this.zooming;
    }

    public void setZooming(Boolean zooming) {
        this.zooming = zooming;
        this.canvas.setScrollBarVisibility(this.isZooming() ? FigureCanvas.NEVER : FigureCanvas.AUTOMATIC);
    }

    private void applyColor(Symbol symbol) {
        RGB color = org.eclipse.scada.vi.ui.draw2d.primitives.Helper.makeColor(symbol.getBackgroundColor());
        if (color != null) {
            this.canvas.setBackground(this.manager.createColor(color));
        }
    }

    private void applyImage(Symbol symbol, SymbolLoader symbolLoader) {
        if (symbol.getBackgroundImage() == null || symbol.getBackgroundImage().isEmpty()) {
            return;
        }
        this.logInfo("Trying to load background image: " + symbol.getBackgroundImage());
        String uriString = symbolLoader.resolveUri(symbol.getBackgroundImage());
        URI uri = URI.createURI((String)uriString);
        this.loadedResources.add(uri);
        try {
            Image img = this.manager.createImageWithDefault(ImageDescriptor.createFromURL((URL)new URL(uriString)));
            this.canvas.setBackgroundImage(img);
        }
        catch (MalformedURLException e) {
            this.logError("Loading background image: " + uriString, e);
        }
    }

    private void logInfo(String string) {
        if (this.controller != null) {
            this.controller.debugLog(string);
        }
    }

    private void logError(String string, Throwable e) {
        if (this.controller != null) {
            this.controller.errorLog(string, e);
        }
    }

    protected FigureCanvas createCanvas() {
        FigureCanvas canvas = new FigureCanvas((Composite)this, 0x100300);
        this.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                VisualInterfaceViewer.this.handleResize(VisualInterfaceViewer.this.getBounds());
            }
        });
        return canvas;
    }

    protected void handleResize(org.eclipse.swt.graphics.Rectangle bounds) {
        if (!this.isZooming()) {
            Rectangle r = new Rectangle(bounds.x, bounds.y, bounds.width, bounds.height);
            this.connectionLayer.setPreferredSize(r.getSize());
            this.setZoom(1.0);
            return;
        }
        Dimension prefSize = this.getPreferredSize(bounds);
        double ar = prefSize.preciseWidth() / prefSize.preciseHeight();
        double newHeight = (double)bounds.width / ar;
        if (newHeight > (double)bounds.height) {
            newHeight = bounds.height;
        }
        double zoom = newHeight / prefSize.preciseHeight();
        this.setZoom(zoom);
    }

    private Dimension getPreferredSize(org.eclipse.swt.graphics.Rectangle bounds) {
        if (this.symbol != null && this.symbol.getDesignSize() != null) {
            return new PrecisionDimension(this.symbol.getDesignSize().getWidth(), this.symbol.getDesignSize().getHeight());
        }
        if (this.figure != null) {
            return this.figure.getPreferredSize(bounds.width, bounds.height);
        }
        return new PrecisionDimension((double)bounds.width, (double)bounds.height);
    }

    private void setZoom(double newZoom) {
        if (this.pane instanceof ScalableLayeredPane) {
            this.pane.setScale(newZoom);
        }
    }

    protected void create(SymbolLoader symbolLoader) {
        try {
            HashMap<String, String> properties = new HashMap<String, String>(this.symbol.getProperties().size());
            for (Map.Entry entry : this.symbol.getProperties().entrySet()) {
                properties.put((String)entry.getKey(), (String)entry.getValue());
            }
            properties.putAll(this.initialProperties);
            this.controller = new SymbolController(this.getShell(), symbolLoader, properties, this.scriptObjects, this.factoryContext);
            Controller controller = this.create(this.symbol.getRoot());
            this.controller.init();
            this.figure = controller.getFigure();
            this.layer.add(this.figure);
            this.factory.createConnections((Layer)this.connectionLayer, this.controller, (EList<Connection>)this.symbol.getConnections());
        }
        catch (Exception e) {
            StatusManager.getManager().handle(StatusHelper.convertStatus((String)"org.eclipse.scada.vi.ui.draw2d", (Throwable)e), 1);
            this.figure = Helper.createErrorFigure(e);
            this.layer.add(this.figure);
        }
        this.canvas.setContents((IFigure)this.pane);
    }

    protected Controller create(Primitive element) throws Exception {
        return this.factory.create(this.controller, element);
    }

    private void internalDispose() {
        this.canvas.setContents(null);
        if (this.controller != null) {
            this.controller.dispose();
        }
        if (this.manager != null) {
            this.manager.dispose();
        }
    }

    public void addSummaryListener(SummaryListener listener) {
        if (this.controller != null) {
            this.controller.addSummaryListener(listener);
        }
    }

    public void removeSummaryListener(SummaryListener listener) {
        if (this.controller != null) {
            this.controller.removeSummaryListener(listener);
        }
    }

    public SummaryInformation getSummary() {
        return this.controller.getSummaryInformation();
    }
}

