/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.vi.ui.draw2d.primitives;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.scada.vi.model.Figure;
import org.eclipse.scada.vi.model.Image;
import org.eclipse.scada.vi.model.Primitive;
import org.eclipse.scada.vi.ui.draw2d.FactoryContext;
import org.eclipse.scada.vi.ui.draw2d.SymbolController;
import org.eclipse.scada.vi.ui.draw2d.loader.SymbolLoader;
import org.eclipse.scada.vi.ui.draw2d.primitives.FigureController;
import org.eclipse.scada.vi.ui.draw2d.primitives.Helper;

public class ImageController
extends FigureController {
    private final Label figure;
    private ImageDescriptor currentImage;
    private final SymbolLoader symbolLoader;
    private final FactoryContext factoryContext;

    public ImageController(FigureCanvas canvas, SymbolController controller, Image element, SymbolLoader symbolLoader, ResourceManager manager, FactoryContext factoryContext) {
        super(controller, manager);
        this.factoryContext = factoryContext;
        this.symbolLoader = symbolLoader;
        this.figure = new Label(){

            public void addNotify() {
                super.addNotify();
                ImageController.this.start();
            }

            public void removeNotify() {
                ImageController.this.stop();
                super.removeNotify();
            }
        };
        controller.addElement((Primitive)element, this);
        this.applyCommon(element);
        this.setImage(element.getUri());
    }

    protected void applyCommon(Image image) {
        super.applyCommon((Figure)image);
        this.figure.setLabelAlignment(Helper.convertAlignment(image.getImageAlignment(), 2));
    }

    @Override
    public void setOpaque(Boolean flag) {
        this.setOpaque(flag, true);
    }

    public void setImage(String uri) {
        if (this.currentImage != null) {
            this.manager.destroyImage(this.currentImage);
            this.currentImage = null;
        }
        if (uri == null || uri.isEmpty()) {
            this.figure.setIcon(null);
        } else {
            try {
                URL url = new URL(this.symbolLoader.resolveUri(uri));
                this.currentImage = ImageDescriptor.createFromURL((URL)url);
                this.figure.setIcon(this.manager.createImageWithDefault(this.currentImage));
                this.factoryContext.loadedResource(URI.createURI((String)url.toString()));
            }
            catch (MalformedURLException malformedURLException) {
                this.figure.setIcon(this.manager.createImageWithDefault(ImageDescriptor.getMissingImageDescriptor()));
            }
        }
    }

    @Override
    protected IFigure getPropertyFigure() {
        return this.figure;
    }
}

