/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.vi.ui.draw2d.primitives;

import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.scada.vi.model.Figure;
import org.eclipse.scada.vi.model.Orientation;
import org.eclipse.scada.vi.model.Primitive;
import org.eclipse.scada.vi.model.Text;
import org.eclipse.scada.vi.ui.draw2d.SymbolController;
import org.eclipse.scada.vi.ui.draw2d.primitives.FigureController;
import org.eclipse.scada.vi.ui.draw2d.primitives.Helper;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Display;

public class TextController
extends FigureController {
    private final Label figure;
    private final FigureCanvas canvas;
    private Double alpha;

    public TextController(FigureCanvas canvas, SymbolController controller, Text element, ResourceManager manager) {
        super(controller, manager);
        this.canvas = canvas;
        this.figure = new Label(element.getText()){

            public void addNotify() {
                super.addNotify();
                TextController.this.start();
            }

            protected void paintFigure(Graphics graphics) {
                Double alpha = TextController.this.getAlpha();
                if (alpha != null) {
                    graphics.setAlpha((int)(Math.max(0.0, Math.min(1.0, alpha)) * 255.0));
                }
                super.paintFigure(graphics);
            }

            public void removeNotify() {
                TextController.this.stop();
                super.removeNotify();
            }
        };
        controller.addElement((Primitive)element, this);
        this.applyCommon(element);
    }

    @Override
    public void setOpaque(Boolean flag) {
        this.setOpaque(flag, false);
    }

    protected void applyCommon(Text element) {
        super.applyCommon((Figure)element);
        this.figure.setTextAlignment(Helper.convertAlignment(element.getTextAlignment(), 2));
        this.figure.setLabelAlignment(Helper.convertAlignment(element.getLabelAlignment(), 2));
        this.figure.setIconAlignment(Helper.convertAlignment(element.getIconAlignment(), 2));
        this.figure.setTextPlacement(TextController.convertOrientation(element.getTextPlacement(), 16));
        this.setAlpha(element.getAlpha());
        this.setFontFull(element.getFontName(), element.getFontSize(), element.isFontBold(), element.isFontItalic());
    }

    public void setTextAlignment(String value) {
        this.figure.setTextAlignment(Helper.convertPosition(value, 2));
    }

    public void setLabelAlignment(String value) {
        this.figure.setLabelAlignment(Helper.convertPosition(value, 2));
    }

    public void setIconAlignment(String value) {
        this.figure.setIconAlignment(Helper.convertPosition(value, 2));
    }

    public void setTextPlacement(String value) {
        this.figure.setTextPlacement(Helper.convertPosition(value, 16));
    }

    public void setFontBold(boolean bold) {
        this.setFontFull(null, null, bold, null);
    }

    public void setFontItalic(boolean italic) {
        this.setFontFull(null, null, null, italic);
    }

    public void setFont(String fontName, Integer fontSize) {
        this.setFontFull(fontName, fontSize, false, false);
    }

    public void setFontFull(String fontName, Integer fontSize, Boolean bold, Boolean italic) {
        this.figure.setFont(this.convertFont(fontName, fontSize, bold, italic));
    }

    private Font convertFont(String fontName, Integer fontSize, Boolean bold, Boolean italic) {
        int n;
        if (fontName == null && fontSize == null && bold == null && italic == null) {
            return null;
        }
        Font font = this.figure.getFont();
        if (font == null) {
            font = this.canvas.getFont();
        }
        if (font == null) {
            font = Display.getDefault().getSystemFont();
        }
        FontData[] fontData = FontDescriptor.copy((FontData[])font.getFontData());
        if (fontName != null) {
            if (fontSize != null && fontSize > 0) {
                fontData = FontDescriptor.createFrom((String)fontName, (int)fontSize, (int)0).getFontData();
            } else {
                int origFontSize = 0;
                FontData[] fontDataArray = fontData;
                int n2 = fontData.length;
                n = 0;
                while (n < n2) {
                    FontData fd = fontDataArray[n];
                    origFontSize = fd.getHeight();
                    ++n;
                }
                fontData = FontDescriptor.createFrom((String)fontName, (int)origFontSize, (int)0).getFontData();
            }
        }
        FontData[] fontDataArray = fontData;
        n = fontData.length;
        int n3 = 0;
        while (n3 < n) {
            FontData fd = fontDataArray[n3];
            if (fontName != null) {
                fd.setName(fontName);
            }
            if (fontSize != null && fontSize > 0) {
                fd.setHeight(fontSize.intValue());
            }
            int style = fd.getStyle();
            if (bold != null) {
                style = bold.booleanValue() ? (style |= 1) : (style &= 0xFFFFFFFE);
            }
            if (italic != null) {
                style = italic.booleanValue() ? (style |= 2) : (style &= 0xFFFFFFFD);
            }
            fd.setStyle(style);
            ++n3;
        }
        return this.manager.createFont(FontDescriptor.createFrom((FontData[])fontData));
    }

    private static int convertOrientation(Orientation orientation, int defaultValue) {
        if (orientation == null) {
            return defaultValue;
        }
        return Helper.convertPosition(orientation.getName(), defaultValue);
    }

    @Override
    public IFigure getPropertyFigure() {
        return this.figure;
    }

    public void setText(String text) {
        this.figure.setText(text);
    }

    public void setAlpha(Double alpha) {
        this.alpha = alpha;
        this.figure.repaint();
    }

    public Double getAlpha() {
        return this.alpha;
    }
}

