/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.core.ui.connection.login.toolbar;

import org.eclipse.scada.core.ui.connection.login.LoginSession;
import org.eclipse.scada.core.ui.connection.login.SessionListener;
import org.eclipse.scada.core.ui.connection.login.SessionManager;
import org.eclipse.scada.core.ui.connection.login.toolbar.Messages;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.menus.WorkbenchWindowControlContribution;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoginStatusControl
extends WorkbenchWindowControlContribution
implements SessionListener {
    private static final Logger logger = LoggerFactory.getLogger(LoginStatusControl.class);
    private Label statusLabel;

    public LoginStatusControl() {
    }

    public LoginStatusControl(String id) {
        super(id);
    }

    public void dispose() {
        super.dispose();
        SessionManager.getDefault().removeListener(this);
    }

    protected Control createControl(Composite parent) {
        logger.debug("Creating control");
        Composite wrapper = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        wrapper.setLayout((Layout)layout);
        this.statusLabel = new Label(wrapper, 0);
        this.statusLabel.setText(Messages.LoginStatusControl_StatusLabel_Text);
        GridData gd = new GridData(4, 0x1000000, false, true);
        gd.widthHint = 150;
        this.statusLabel.setLayoutData((Object)gd);
        SessionManager.getDefault().addListener(this);
        return wrapper;
    }

    @Override
    public void sessionChanged(LoginSession session) {
        logger.info("Session changed - session: {}", (Object)session);
        if (session == null) {
            this.statusLabel.setText(Messages.LoginStatusControl_StatusLabel_NoSession);
        } else {
            this.statusLabel.setText(String.format(Messages.LoginStatusControl_StatusLabel_SessionFormat, this.getUserName(session.getUsername()), session.getLoginContext().getName()));
        }
    }

    private Object getUserName(String username) {
        if (username == null) {
            return Messages.LoginStatusControl_Text_Anonymous;
        }
        return username;
    }
}

