/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.ui.testing.navigator;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.databinding.observable.set.WritableSet;
import org.eclipse.scada.ae.BrowserListener;
import org.eclipse.scada.ae.connection.provider.ConnectionService;
import org.eclipse.scada.ae.ui.connection.data.BrowserEntryBean;
import org.eclipse.scada.ae.ui.testing.navigator.QueryListWrapper;
import org.eclipse.scada.core.ui.connection.data.ConnectionHolder;

public class ConnectionWrapper
extends WritableSet
implements PropertyChangeListener {
    private final ConnectionHolder holder;
    private ConnectionService service;
    private final Map<String, BrowserEntryBean> entries = new HashMap<String, BrowserEntryBean>();
    private BrowserListener listener;
    private QueryListWrapper wrapper;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectionWrapper(ConnectionHolder target) {
        this.holder = target;
        ConnectionWrapper connectionWrapper = this;
        synchronized (connectionWrapper) {
            this.holder.addPropertyChangeListener("connectionService", (PropertyChangeListener)this);
            this.triggerUpdate();
        }
    }

    public synchronized void dispose() {
        this.holder.removePropertyChangeListener("connectionService", (PropertyChangeListener)this);
        super.dispose();
    }

    @Override
    public synchronized void propertyChange(PropertyChangeEvent evt) {
        this.triggerUpdate();
    }

    private void triggerUpdate() {
        this.getRealm().asyncExec(new Runnable(){

            @Override
            public void run() {
                ConnectionWrapper.this.update();
            }
        });
    }

    private void update() {
        this.setStale(true);
        try {
            ConnectionService service;
            this.clearConnection();
            this.service = service = (ConnectionService)this.holder.getConnectionService();
            if (this.service != null) {
                this.setupConnection();
            }
        }
        finally {
            this.setStale(false);
        }
    }

    private void setupConnection() {
        this.wrapper = new QueryListWrapper(this);
        this.add(this.wrapper);
    }

    private void clearConnection() {
        this.clear();
        if (this.service != null) {
            this.service.getConnection().removeBrowserListener(this.listener);
        }
        this.listener = null;
        if (this.wrapper != null) {
            this.remove(this.wrapper);
            this.wrapper.dispose();
            this.wrapper = null;
        }
        this.entries.clear();
        this.service = null;
    }

    public ConnectionService getService() {
        return this.service;
    }
}

