/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.ui.testing.views;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.scada.ae.ui.connection.data.BrowserEntryBean;
import org.eclipse.scada.ae.ui.testing.views.JobViewPart;
import org.eclipse.scada.ui.utils.SelectionHelper;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;

public abstract class AbstractEntryViewPart
extends JobViewPart {
    protected BrowserEntryBean entry;
    private ISelectionListener selectionListener;

    public void dispose() {
        this.removeSelectionListener();
        super.dispose();
    }

    protected void addSelectionListener() {
        if (this.selectionListener == null) {
            this.selectionListener = new ISelectionListener(){

                public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                    AbstractEntryViewPart.this.setSelection(selection);
                }
            };
            this.getViewSite().getWorkbenchWindow().getSelectionService().addSelectionListener(this.selectionListener);
        }
    }

    protected void removeSelectionListener() {
        if (this.selectionListener != null) {
            this.getViewSite().getWorkbenchWindow().getSelectionService().removeSelectionListener(this.selectionListener);
            this.selectionListener = null;
        }
    }

    protected synchronized void setSelection(ISelection selection) {
        BrowserEntryBean browserEntry = (BrowserEntryBean)SelectionHelper.first((ISelection)selection, BrowserEntryBean.class);
        if (browserEntry != this.entry && browserEntry != null && this.isSupported(browserEntry)) {
            this.clear();
            if (browserEntry != null) {
                this.setEntry(browserEntry);
            }
        }
    }

    protected abstract boolean isSupported(BrowserEntryBean var1);

    protected abstract void clear();

    protected abstract void setEntry(BrowserEntryBean var1);
}

