/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.ui.testing.wizard;

import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class QueryStringWizardPage
extends WizardPage {
    private Text filterEntry;
    private Text filterTypeEntry;

    public QueryStringWizardPage() {
        super("Query String Entry Page");
        this.setTitle("Query String Entry Page");
        this.setDescription("Enter a query type and expression");
    }

    public void createControl(Composite parent) {
        Composite group = new Composite(parent, 0);
        group.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label(group, 0);
        label.setText("Filter Type:");
        label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.filterTypeEntry = new Text(group, 2052);
        this.filterTypeEntry.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.filterTypeEntry.setText("ldap");
        this.filterTypeEntry.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                QueryStringWizardPage.this.update();
            }
        });
        label = new Label(group, 0);
        label.setText("Filter String:");
        label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.filterEntry = new Text(group, 2050);
        this.filterEntry.setLayoutData((Object)new GridData(4, 4, true, true));
        this.filterEntry.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                QueryStringWizardPage.this.update();
            }
        });
        this.setControl((Control)group);
        this.update();
    }

    private void update() {
        String filterType = this.filterTypeEntry.getText();
        String filterData = this.filterEntry.getText();
        boolean warning = false;
        if ("".equals(filterType)) {
            this.setPageComplete(false);
            this.setMessage("Select a filter type", 3);
            return;
        }
        if ("".equals(filterData)) {
            this.setMessage("Empty filter string might be a problem", 2);
            warning = true;
        }
        if (!warning) {
            this.setMessage(null);
        }
        this.setPageComplete(true);
    }

    public String getFilterType() {
        return this.filterTypeEntry.getText();
    }

    public String getFilterData() {
        return this.filterEntry.getText();
    }
}

