/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ca.ui.editor.config;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.scada.ca.ui.editor.ConfigurationFormInformation;
import org.eclipse.scada.ca.ui.editor.config.BasicEditor;
import org.eclipse.scada.ca.ui.editor.config.FormEditor;
import org.eclipse.scada.ca.ui.editor.input.ConfigurationEditorInput;
import org.eclipse.scada.ca.ui.editor.internal.Activator;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.statushandlers.StatusManager;

public class MultiConfigurationEditor
extends MultiPageEditorPart {
    public static final String EDITOR_ID = "org.eclipse.scada.ca.ui.connection.editors.MultiConfigurationEditor";
    private BasicEditor basicEditor;

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setPartName(input.toString());
        this.setSite((IWorkbenchPartSite)site);
        try {
            this.setInput(input);
        }
        catch (Exception e) {
            throw new PartInitException("Failed to initialize editor", (Throwable)e);
        }
    }

    protected void createPages() {
        IEditorInput input = this.getEditorInput();
        if (input instanceof ConfigurationEditorInput) {
            try {
                int i = 0;
                String factoryId = ((ConfigurationEditorInput)input).getFactoryId();
                for (ConfigurationFormInformation info : Activator.findMatching(factoryId)) {
                    try {
                        this.addPage(i, (IEditorPart)new FormEditor(info), this.getEditorInput());
                        this.setPageText(i, info.getLabel());
                        ++i;
                    }
                    catch (CoreException e) {
                        StatusManager.getManager().handle(e.getStatus(), 2);
                    }
                }
                this.basicEditor = new BasicEditor();
                this.addPage(i, (IEditorPart)this.basicEditor, this.getEditorInput());
                this.setPageText(i, "Basic Editor");
            }
            catch (PartInitException e) {
                StatusManager.getManager().handle(e.getStatus(), 4);
            }
        }
    }

    protected void setInput(IEditorInput input) {
        if (input instanceof ConfigurationEditorInput) {
            ConfigurationEditorInput configurationInput = (ConfigurationEditorInput)input;
            configurationInput.performLoad((IProgressMonitor)new NullProgressMonitor());
        }
        super.setInput(input);
    }

    public void doSave(IProgressMonitor monitor) {
        IEditorInput input = this.getEditorInput();
        if (input instanceof ConfigurationEditorInput) {
            ((ConfigurationEditorInput)input).performSave(monitor);
        }
    }

    public void refresh() {
        IEditorInput input = this.getEditorInput();
        if (input instanceof ConfigurationEditorInput) {
            ((ConfigurationEditorInput)input).performLoad((IProgressMonitor)new NullProgressMonitor());
        }
    }

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void handleInsert() {
        this.basicEditor.handleInsert();
    }
}

