/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.sec.ui;

import java.util.List;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.jface.databinding.swt.DisplayRealm;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.scada.sec.ui.CallbackWidgetFactory;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class CallbackDialog
extends TitleAreaDialog {
    private final List<CallbackWidgetFactory> factories;
    private DataBindingContext dbc;

    public CallbackDialog(Shell parentShell, List<CallbackWidgetFactory> callbacks) {
        super(parentShell);
        this.factories = callbacks;
    }

    public boolean openDialog() {
        if (this.factories.isEmpty()) {
            return false;
        }
        this.open();
        return true;
    }

    protected Control createDialogArea(Composite parent) {
        Composite wrapper = (Composite)super.createDialogArea(parent);
        this.initializeDialogUnits((Control)wrapper);
        Composite contents = this.createComposite(wrapper);
        contents.setLayoutData((Object)new GridData(4, 4, true, true));
        Dialog.applyDialogFont((Control)wrapper);
        return wrapper;
    }

    private Composite createComposite(Composite wrapper) {
        this.dbc = new DataBindingContext(DisplayRealm.getRealm((Display)wrapper.getDisplay()));
        wrapper.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                CallbackDialog.this.dbc.dispose();
            }
        });
        Composite composite = new Composite(wrapper, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        for (CallbackWidgetFactory factory : this.factories) {
            factory.createGridWidgets(this.dbc, composite);
        }
        return composite;
    }

    protected void okPressed() {
        for (CallbackWidgetFactory factory : this.factories) {
            factory.complete();
        }
        super.okPressed();
    }
}

