/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.sec.ui;

import java.util.concurrent.CancellationException;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.scada.sec.callback.Callback;
import org.eclipse.scada.sec.callback.ConfirmationCallback;
import org.eclipse.scada.utils.concurrent.AbstractFuture;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ConfirmationDialogFuture
extends AbstractFuture<Callback[]> {
    public ConfirmationDialogFuture(final Display display, final Shell parentShell, final Callback[] callbacks, final String dialogTitle) {
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                ConfirmationDialogFuture.this.openDialog(display, parentShell, callbacks, dialogTitle);
            }
        });
    }

    protected void openDialog(Display display, Shell parentShell, Callback[] callbacks, String dialogTitle) {
        try {
            Callback[] callbackArray = callbacks;
            int n = callbacks.length;
            int n2 = 0;
            while (n2 < n) {
                Callback cb = callbackArray[n2];
                if (cb instanceof ConfirmationCallback) {
                    Boolean result = this.showDialog((ConfirmationCallback)cb, display, parentShell, dialogTitle);
                    if (result == null) {
                        this.setError(new CancellationException("Cancelled by user request"));
                    } else {
                        ((ConfirmationCallback)cb).setValue(result);
                    }
                } else {
                    cb.cancel();
                }
                ++n2;
            }
            this.setResult(callbacks);
        }
        catch (Exception e) {
            this.setError(e);
        }
    }

    private Boolean showDialog(ConfirmationCallback cb, Display display, Shell parentShell, String dialogTitle) {
        switch (cb.getConfirmationType()) {
            case CONFIRM: {
                return MessageDialog.openConfirm((Shell)parentShell, (String)dialogTitle, (String)cb.getLabel()) ? Boolean.valueOf(true) : null;
            }
            case ERROR: {
                MessageDialog.openError((Shell)parentShell, (String)dialogTitle, (String)cb.getLabel());
                return true;
            }
            case WARNING: {
                MessageDialog.openWarning((Shell)parentShell, (String)dialogTitle, (String)cb.getLabel());
                return true;
            }
            case INFORMATION: {
                MessageDialog.openInformation((Shell)parentShell, (String)dialogTitle, (String)cb.getLabel());
                return true;
            }
            case QUESTION: {
                return MessageDialog.openQuestion((Shell)parentShell, (String)dialogTitle, (String)cb.getLabel());
            }
            case QUESTION_WITH_CANCEL: {
                MessageDialog dialog = new MessageDialog(parentShell, dialogTitle, null, cb.getLabel(), 6, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
                int result = dialog.open();
                if (result == 2) {
                    return null;
                }
                if (result == 0) {
                    return true;
                }
                return false;
            }
        }
        throw new IllegalArgumentException(String.format("Unable to process type: %s", cb.getConfirmationType()));
    }
}

