/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.sec.ui;

import java.util.List;
import org.eclipse.scada.sec.callback.Callback;
import org.eclipse.scada.sec.ui.CallbackDialog;
import org.eclipse.scada.sec.ui.CallbackWidgetFactory;
import org.eclipse.scada.utils.concurrent.AbstractFuture;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class DialogFuture
extends AbstractFuture<Callback[]> {
    private CallbackDialog dlg;
    private final Display display;
    private final Callback[] callbacks;
    private final List<CallbackWidgetFactory> factories;
    private String title;
    private String message;
    private final Shell parentShell;

    public DialogFuture(Display display, Callback[] callbacks, List<CallbackWidgetFactory> factories) {
        this.parentShell = null;
        this.display = display;
        this.callbacks = callbacks;
        this.factories = factories;
    }

    public DialogFuture(Shell parentShell, Callback[] callbacks, List<CallbackWidgetFactory> factories) {
        this.parentShell = parentShell;
        this.display = parentShell.getDisplay();
        this.callbacks = callbacks;
        this.factories = factories;
    }

    protected Shell getParentShell() {
        if (this.parentShell != null) {
            return this.parentShell;
        }
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        if (shell != null) {
            return shell;
        }
        return this.display.getActiveShell();
    }

    public void openDialog() {
        if (this.isCancelled() || this.dlg != null) {
            return;
        }
        this.dlg = new CallbackDialog(this.getParentShell(), this.factories);
        this.dlg.setBlockOnOpen(false);
        if (this.dlg.openDialog()) {
            this.dlg.getShell().setText(this.title);
            this.dlg.setTitle(this.title);
            this.dlg.setMessage(this.message);
            this.dlg.getShell().setFocus();
            this.dlg.getShell().addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    DialogFuture.this.processDispose();
                }
            });
        } else {
            this.setResult(this.callbacks);
            this.dlg = null;
        }
    }

    public void setEarlyResult(Callback[] result) {
        this.setResult(result);
    }

    public void setErrorResult(Throwable error) {
        this.setError(error);
    }

    protected void processDispose() {
        if (this.dlg.getReturnCode() != 0) {
            this.setError(new InterruptedException("Interrupted by user"));
        } else {
            this.setResult(this.callbacks);
        }
        this.dlg = null;
    }

    protected void closeDialog() {
        if (this.dlg != null) {
            this.dlg.close();
            this.dlg = null;
        }
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        if (super.cancel(mayInterruptIfRunning)) {
            this.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    DialogFuture.this.closeDialog();
                }
            });
            return true;
        }
        return false;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setMessage(String message) {
        this.message = message;
    }
}

