/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ui.chart.viewer;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.beans.PojoObservables;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.databinding.EMFObservables;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.scada.ui.chart.model.ArchiveChannel;
import org.eclipse.scada.ui.chart.model.ChartPackage;
import org.eclipse.scada.ui.chart.viewer.AbstractObserver;
import org.eclipse.scada.ui.chart.viewer.ArchiveSeriesViewer;
import org.eclipse.scada.ui.chart.viewer.ChartViewer;
import org.eclipse.scada.ui.chart.viewer.LinePropertiesBinder;
import org.eclipse.scada.ui.chart.viewer.XAxisViewer;
import org.eclipse.scada.ui.chart.viewer.YAxisViewer;
import org.eclipse.scada.ui.chart.viewer.input.ArchiveChannelInput;
import org.eclipse.scada.ui.chart.viewer.input.QueryChannelSeriesData;
import org.eclipse.scada.ui.chart.viewer.input.QuerySeriesData;

public class ArchiveChannelViewer
extends AbstractObserver {
    public static final String PROP_INPUT = "input";
    private String channelName;
    private QuerySeriesData querySeriesData;
    private final ChartViewer viewer;
    private QueryChannelSeriesData data;
    private ArchiveChannelInput input;
    private XAxisViewer xAxisViewer;
    private YAxisViewer yAxisViewer;
    private final IObservableValue inputObservable;
    private final IObservableValue linePropertiesObservable;
    private final ResourceManager resourceManager;

    public ArchiveChannelViewer(DataBindingContext dbc, ArchiveChannel element, ChartViewer viewer, ResourceManager resourceManager, ArchiveSeriesViewer archiveSeriesViewer) {
        this.viewer = viewer;
        this.resourceManager = resourceManager;
        this.addBinding(dbc.bindValue(PojoObservables.observeValue((Object)((Object)this), (String)"channelName"), EMFObservables.observeValue((EObject)element, (EStructuralFeature)ChartPackage.Literals.ARCHIVE_CHANNEL__NAME)));
        this.addBinding(dbc.bindValue(PojoObservables.observeValue((Object)((Object)this), (String)"querySeriesData"), BeansObservables.observeValue((Object)archiveSeriesViewer, (String)"querySeriesData")));
        this.addBinding(dbc.bindValue(PojoObservables.observeValue((Object)((Object)this), (String)"XAxisViewer"), BeansObservables.observeValue((Object)archiveSeriesViewer, (String)"XAxis")));
        this.addBinding(dbc.bindValue(PojoObservables.observeValue((Object)((Object)this), (String)"YAxisViewer"), BeansObservables.observeValue((Object)archiveSeriesViewer, (String)"YAxis")));
        this.inputObservable = BeansObservables.observeValue((Object)((Object)this), (String)PROP_INPUT);
        this.linePropertiesObservable = EMFObservables.observeValue((EObject)element, (EStructuralFeature)ChartPackage.Literals.ARCHIVE_CHANNEL__LINE_PROPERTIES);
        this.addBinding(dbc.bindValue(PojoObservables.observeDetailValue((IObservableValue)this.inputObservable, (String)"label", null), EMFObservables.observeValue((EObject)element, (EStructuralFeature)ChartPackage.Literals.ARCHIVE_CHANNEL__LABEL)));
        this.addBindings(LinePropertiesBinder.bind(dbc, this.inputObservable, this.linePropertiesObservable));
    }

    public void setChannelName(String channelName) {
        this.disposeInput();
        this.channelName = channelName;
        this.checkCreateInput();
    }

    public String getChannelName() {
        return this.channelName;
    }

    public QuerySeriesData getQuerySeriesData() {
        return this.querySeriesData;
    }

    public void setQuerySeriesData(QuerySeriesData querySeriesData) {
        this.disposeInput();
        this.querySeriesData = querySeriesData;
        this.checkCreateInput();
    }

    private void checkCreateInput() {
        if (this.querySeriesData != null && this.xAxisViewer != null && this.yAxisViewer != null && this.channelName != null) {
            this.data = new QueryChannelSeriesData(this.viewer.getRealm(), this.xAxisViewer.getAxis(), this.yAxisViewer.getAxis(), this.querySeriesData, this.channelName);
            this.setInput(new ArchiveChannelInput(this.viewer, this.data, this.resourceManager));
        }
    }

    @Override
    public void dispose() {
        this.inputObservable.dispose();
        this.linePropertiesObservable.dispose();
        this.disposeInput();
        super.dispose();
    }

    private void disposeInput() {
        if (this.input != null) {
            this.input.dispose();
            this.setInput(null);
        }
        if (this.data != null) {
            this.data.dispose();
            this.data = null;
        }
    }

    public XAxisViewer getXAxisViewer() {
        return this.xAxisViewer;
    }

    public void setXAxisViewer(XAxisViewer xAxisViewer) {
        this.disposeInput();
        this.xAxisViewer = xAxisViewer;
        this.checkCreateInput();
    }

    public YAxisViewer getYAxisViewer() {
        return this.yAxisViewer;
    }

    public void setYAxisViewer(YAxisViewer yAxisViewer) {
        this.disposeInput();
        this.yAxisViewer = yAxisViewer;
        this.checkCreateInput();
    }

    public ArchiveChannelInput getInput() {
        return this.input;
    }

    public void setInput(ArchiveChannelInput input) {
        this.input = input;
        this.firePropertyChange(PROP_INPUT, this.input, this.input);
    }
}

