/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ui.chart.viewer;

import java.util.Calendar;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.databinding.AggregateValidationStatus;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateListStrategy;
import org.eclipse.core.databinding.beans.PojoObservables;
import org.eclipse.core.databinding.observable.Observables;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.databinding.EMFObservables;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.scada.chart.Realm;
import org.eclipse.scada.chart.swt.ChartRenderer;
import org.eclipse.scada.chart.swt.DisplayRealm;
import org.eclipse.scada.chart.swt.DisposeListener;
import org.eclipse.scada.chart.swt.controller.AbstractMouseHandler;
import org.eclipse.scada.chart.swt.controller.MouseHover;
import org.eclipse.scada.chart.swt.render.CurrentTimeRuler;
import org.eclipse.scada.chart.swt.render.Renderer;
import org.eclipse.scada.chart.swt.render.TitleRenderer;
import org.eclipse.scada.da.ui.connection.data.Item;
import org.eclipse.scada.ui.chart.AxisConverter;
import org.eclipse.scada.ui.chart.configuration.Charts;
import org.eclipse.scada.ui.chart.model.Chart;
import org.eclipse.scada.ui.chart.model.ChartPackage;
import org.eclipse.scada.ui.chart.model.XAxis;
import org.eclipse.scada.ui.chart.model.YAxis;
import org.eclipse.scada.ui.chart.viewer.ChartContext;
import org.eclipse.scada.ui.chart.viewer.ChartContextImpl;
import org.eclipse.scada.ui.chart.viewer.ChartViewerListener;
import org.eclipse.scada.ui.chart.viewer.ExtensionSpaceProvider;
import org.eclipse.scada.ui.chart.viewer.InputManager;
import org.eclipse.scada.ui.chart.viewer.ResetHandler;
import org.eclipse.scada.ui.chart.viewer.SimpleAxisLocator;
import org.eclipse.scada.ui.chart.viewer.XAxisManager;
import org.eclipse.scada.ui.chart.viewer.XAxisViewer;
import org.eclipse.scada.ui.chart.viewer.YAxisManager;
import org.eclipse.scada.ui.chart.viewer.YAxisViewer;
import org.eclipse.scada.ui.chart.viewer.controller.ControllerManager;
import org.eclipse.scada.ui.chart.viewer.input.ChartInput;
import org.eclipse.scada.ui.chart.viewer.profile.ProfileManager;
import org.eclipse.scada.ui.utils.AbstractSelectionProvider;
import org.eclipse.scada.ui.utils.SelectionHelper;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChartViewer
extends AbstractSelectionProvider {
    private static final Logger logger = LoggerFactory.getLogger(ChartViewer.class);
    private final ChartRenderer manager;
    private final WritableList items = new WritableList(new LinkedList(), ChartInput.class);
    private final IObservableList unmodItems = Observables.unmodifiableObservableList((IObservableList)this.items);
    private CurrentTimeRuler timeRuler;
    private ChartInput selection;
    private final Chart chart;
    private final DataBindingContext ctx;
    private final ResourceManager resourceManager;
    private final YAxisManager leftManager;
    private final YAxisManager rightManager;
    private final XAxisManager topManager;
    private final XAxisManager bottomManager;
    private XAxisViewer timeRulerAxis;
    private boolean showTimeRuler;
    private final Realm realm;
    private final SimpleAxisLocator<XAxis, XAxisViewer> xLocator;
    private final SimpleAxisLocator<YAxis, YAxisViewer> yLocator;
    private final InputManager inputManager;
    private XAxis timeRulerAxisElement;
    private final Set<ChartViewerListener> listeners = new LinkedHashSet<ChartViewerListener>();
    private boolean mutable;
    private boolean hoverable;
    private MouseHover mouseHover;
    private final ControllerManager controllerManager;
    private final ProfileManager profileManager;
    private final ChartContext chartContext;
    private TitleRenderer titleRenderer;
    private Display display;
    private final WritableList selectedXAxis = new WritableList();

    public ChartViewer(Display display, ChartRenderer chartRenderer, Chart chart, ExtensionSpaceProvider extensionSpaceProvider, ResetHandler resetHandler) {
        this.chart = chart;
        this.display = display;
        this.resourceManager = new LocalResourceManager(JFaceResources.getResources((Display)this.display));
        this.ctx = new DataBindingContext(SWTObservables.getRealm((Display)this.display));
        AggregateValidationStatus status = new AggregateValidationStatus(this.ctx, 1);
        status.addValueChangeListener(new IValueChangeListener(){

            public void handleValueChange(ValueChangeEvent event) {
                if (event.diff.getNewValue() == null) {
                    return;
                }
                Status value = (Status)event.diff.getNewValue();
                if (value.isOK() || value.getException() == null) {
                    return;
                }
                logger.warn("Changed", value.getException());
            }
        });
        this.manager = chartRenderer;
        this.manager.setStale(true);
        this.realm = new DisplayRealm(this.display);
        this.manager.createDropTarget(new Transfer[]{LocalSelectionTransfer.getTransfer()}, this.createDropTarget());
        this.titleRenderer = new TitleRenderer(this.manager);
        this.manager.addRenderer((Renderer)this.titleRenderer, -100);
        this.leftManager = new YAxisManager(this.ctx, this.manager, true);
        this.ctx.bindList((IObservableList)this.leftManager.getList(), EMFObservables.observeList((EObject)chart, (EStructuralFeature)ChartPackage.Literals.CHART__LEFT));
        this.rightManager = new YAxisManager(this.ctx, this.manager, false);
        this.ctx.bindList((IObservableList)this.rightManager.getList(), EMFObservables.observeList((EObject)chart, (EStructuralFeature)ChartPackage.Literals.CHART__RIGHT));
        this.topManager = new XAxisManager(this.ctx, this.manager, true);
        this.ctx.bindList((IObservableList)this.topManager.getList(), EMFObservables.observeList((EObject)chart, (EStructuralFeature)ChartPackage.Literals.CHART__TOP));
        this.bottomManager = new XAxisManager(this.ctx, this.manager, false);
        this.ctx.bindList((IObservableList)this.bottomManager.getList(), EMFObservables.observeList((EObject)chart, (EStructuralFeature)ChartPackage.Literals.CHART__BOTTOM));
        this.xLocator = new SimpleAxisLocator<XAxis, XAxisViewer>(this.topManager, this.bottomManager);
        this.yLocator = new SimpleAxisLocator<YAxis, YAxisViewer>(this.leftManager, this.rightManager);
        this.inputManager = new InputManager(this.ctx, this, this.resourceManager, this.xLocator, this.yLocator);
        this.ctx.bindList((IObservableList)this.inputManager.getList(), EMFObservables.observeList((EObject)chart, (EStructuralFeature)ChartPackage.Literals.CHART__INPUTS));
        this.ctx.bindValue(PojoObservables.observeValue((Object)this.titleRenderer, (String)"title"), EMFObservables.observeValue((EObject)this.chart, (EStructuralFeature)ChartPackage.Literals.CHART__TITLE));
        this.ctx.bindValue(PojoObservables.observeValue((Object)((Object)this), (String)"showCurrentTimeRuler"), EMFObservables.observeValue((EObject)this.chart, (EStructuralFeature)ChartPackage.Literals.CHART__SHOW_CURRENT_TIME_RULER));
        this.ctx.bindValue(PojoObservables.observeValue((Object)((Object)this), (String)"mutable"), EMFObservables.observeValue((EObject)this.chart, (EStructuralFeature)ChartPackage.Literals.CHART__MUTABLE));
        this.ctx.bindValue(PojoObservables.observeValue((Object)((Object)this), (String)"hoverable"), EMFObservables.observeValue((EObject)this.chart, (EStructuralFeature)ChartPackage.Literals.CHART__HOVERABLE));
        this.ctx.bindValue(PojoObservables.observeValue((Object)((Object)this), (String)"chartBackground"), EMFObservables.observeValue((EObject)this.chart, (EStructuralFeature)ChartPackage.Literals.CHART__BACKGROUND_COLOR));
        this.ctx.bindValue(PojoObservables.observeValue((Object)((Object)this), (String)"timeRulerAxis"), EMFObservables.observeValue((EObject)this.chart, (EStructuralFeature)ChartPackage.Literals.CHART__TIME_RULER_AXIS));
        this.ctx.bindList((IObservableList)this.selectedXAxis, EMFObservables.observeList((EObject)chart, (EStructuralFeature)ChartPackage.Literals.CHART__SELECTED_XAXIS), null, new UpdateListStrategy().setConverter(new AxisConverter<XAxis, org.eclipse.scada.chart.XAxis, XAxisViewer>(XAxis.class, org.eclipse.scada.chart.XAxis.class, this.xLocator)));
        this.chartContext = new ChartContextImpl(this.xLocator, this.yLocator, extensionSpaceProvider, chartRenderer, chart, resetHandler, this.unmodItems);
        this.controllerManager = new ControllerManager(this.ctx, this.ctx.getValidationRealm(), this.chartContext);
        this.ctx.bindList((IObservableList)this.controllerManager.getList(), EMFObservables.observeList((EObject)chart, (EStructuralFeature)ChartPackage.Literals.CHART__CONTROLLERS));
        this.profileManager = new ProfileManager(this.ctx, this.ctx.getValidationRealm(), extensionSpaceProvider, this.chartContext);
        this.ctx.bindList((IObservableList)this.profileManager.getList(), EMFObservables.observeList((EObject)chart, (EStructuralFeature)ChartPackage.Literals.CHART__PROFILES));
        this.ctx.bindValue(PojoObservables.observeValue((Object)this.profileManager, (String)"type"), EMFObservables.observeValue((EObject)chart, (EStructuralFeature)ChartPackage.Literals.CHART__PROFILE_SWITCHER_TYPE));
        this.ctx.bindValue(PojoObservables.observeValue((Object)this.profileManager, (String)"activeProfile"), EMFObservables.observeValue((EObject)chart, (EStructuralFeature)ChartPackage.Literals.CHART__ACTIVE_PROFILE));
        this.manager.setStale(false);
        this.startTimer();
        this.manager.addDisposeListener(new DisposeListener(){

            public void onDispose() {
                ChartViewer.this.handleDispose();
            }
        });
        this.setSelection((ISelection)new StructuredSelection((Object)this));
        this.updateState();
    }

    public boolean isHoverable() {
        return this.hoverable;
    }

    public void setHoverable(boolean hoverable) {
        this.hoverable = hoverable;
        this.updateState();
    }

    public ChartRenderer getChartRenderer() {
        return this.manager;
    }

    protected void handleMouseMove(MouseEvent e, long timestamp) {
        this.setInputSelection(timestamp);
    }

    private void setInputSelection(long timestamp) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(timestamp);
        for (Object input : this.items) {
            ((ChartInput)input).setSelection(c);
        }
    }

    public void setMutable(boolean mutable) {
        this.mutable = mutable;
    }

    public boolean isMutable() {
        return this.mutable;
    }

    public void addChartViewerListener(ChartViewerListener chartViewerListener) {
        this.listeners.add(chartViewerListener);
    }

    public void removeChartViewerListener(ChartViewerListener chartViewerListener) {
        this.listeners.remove(chartViewerListener);
    }

    private void fireInputAdded(final ChartInput input) {
        for (final ChartViewerListener listener : this.listeners) {
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() throws Exception {
                    listener.inputAdded(input);
                }
            });
        }
    }

    private void fireInputRemoved(final ChartInput input) {
        for (final ChartViewerListener listener : this.listeners) {
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() throws Exception {
                    listener.inputRemoved(input);
                }
            });
        }
    }

    public Realm getRealm() {
        return this.realm;
    }

    protected void updateState() {
        org.eclipse.scada.chart.XAxis x = this.getTimeRulerViewer();
        if (this.mouseHover != null) {
            this.mouseHover.dispose();
            this.mouseHover = null;
        }
        if (this.isHoverable()) {
            this.mouseHover = new MouseHover(this.manager);
            this.mouseHover.setVisible(true);
        }
        if (this.timeRuler == null && this.showTimeRuler && x != null) {
            this.timeRuler = new CurrentTimeRuler(x);
            this.timeRuler.setColor(new RGB(0, 0, 255));
            this.manager.addRenderer((Renderer)this.timeRuler, 100);
        } else if (this.timeRuler != null && !this.showTimeRuler || x == null) {
            this.disposeTimeRuler();
        }
    }

    protected void disposeTimeRuler() {
        this.manager.removeRenderer((Renderer)this.timeRuler);
        this.timeRuler = null;
    }

    private org.eclipse.scada.chart.XAxis getTimeRulerViewer() {
        return this.timeRulerAxis != null ? this.timeRulerAxis.getAxis() : null;
    }

    public XAxis getTimeRulerAxis() {
        return this.timeRulerAxisElement;
    }

    public void setTimeRulerAxis(XAxis axis) {
        XAxisViewer newSelection = this.xLocator.findAxis(axis);
        if (this.timeRulerAxis == newSelection) {
            return;
        }
        this.timeRulerAxis = newSelection;
        this.timeRulerAxisElement = axis;
        this.disposeTimeRuler();
        this.updateState();
    }

    public void setChartBackground(RGB rgb) {
        this.manager.setChartBackground(rgb);
        this.manager.refresh();
    }

    public RGB getChartBackground() {
        return this.manager.getChartBackground();
    }

    protected void handleDispose() {
        this.titleRenderer.dispose();
        this.inputManager.dispose();
        this.topManager.dispose();
        this.bottomManager.dispose();
        this.leftManager.dispose();
        this.rightManager.dispose();
        this.manager.dispose();
        this.ctx.dispose();
    }

    private DropTargetAdapter createDropTarget() {
        return new DropTargetAdapter(){

            public void dragEnter(DropTargetEvent event) {
                event.detail = 0;
                if (!ChartViewer.this.mutable) {
                    return;
                }
                ISelection selection = LocalSelectionTransfer.getTransfer().getSelection();
                List data = SelectionHelper.list((ISelection)selection, Item.class);
                if (!data.isEmpty()) {
                    event.detail = 1;
                    return;
                }
                data = SelectionHelper.list((ISelection)selection, org.eclipse.scada.hd.ui.connection.data.Item.class);
                if (!data.isEmpty()) {
                    event.detail = 1;
                    return;
                }
            }

            public void drop(DropTargetEvent event) {
                ChartViewer.this.handleDrop();
            }
        };
    }

    public void setShowCurrentTimeRuler(boolean state) {
        this.showTimeRuler = state;
        this.updateState();
    }

    public boolean isShowCurrentTimeRuler() {
        return this.showTimeRuler;
    }

    private void startTimer() {
        if (this.display.isDisposed()) {
            return;
        }
        this.display.timerExec(250, new Runnable(){

            @Override
            public void run() {
                if (ChartViewer.this.manager.isDisposed()) {
                    return;
                }
                ChartViewer.this.tick();
                ChartViewer.this.startTimer();
            }
        });
    }

    public void addInput(ChartInput input) {
        if (this.items.size() == 1) {
            ((ChartInput)this.items.get(0)).setSelection(false);
        }
        if (!this.items.add((Object)input)) {
            return;
        }
        if (this.items.size() == 1) {
            this.setSelection(input);
        }
        this.fireInputAdded(input);
    }

    public void removeInput(ChartInput input) {
        if (input == this.selection) {
            this.setSelection(null);
        }
        if (this.items.remove((Object)input)) {
            this.fireInputRemoved(input);
        }
    }

    public void setSelection(ChartInput chartInput) {
        if (chartInput != null && !this.items.contains((Object)chartInput)) {
            return;
        }
        this.selection = chartInput;
        for (Object input : this.items) {
            ((ChartInput)input).setSelection(false);
        }
        if (chartInput != null) {
            chartInput.setSelection(true);
        }
    }

    public void tick() {
        long now = System.currentTimeMillis();
        boolean forceUpdate = false;
        try {
            this.manager.setStale(true);
            for (Object item : this.items) {
                if (!((ChartInput)item).tick(now)) continue;
                forceUpdate = true;
            }
            if (this.timeRuler != null) {
                forceUpdate = this.timeRuler.showingCurrentTime();
            }
        }
        finally {
            this.manager.setStale(false, forceUpdate);
        }
    }

    public void setFocus() {
        this.manager.setFocus();
        this.setSelection((ISelection)new StructuredSelection((Object)this));
    }

    public void dispose() {
        Object[] items = this.items.toArray();
        this.items.clear();
        Object[] objectArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            Object item = objectArray[n2];
            ((ChartInput)item).dispose();
            ++n2;
        }
        this.controllerManager.dispose();
    }

    public IObservableList getItems() {
        return this.unmodItems;
    }

    protected void processX(AbstractMouseHandler.AxisFunction<org.eclipse.scada.chart.XAxis> func) {
        for (Object o : this.selectedXAxis) {
            func.process((Object)((org.eclipse.scada.chart.XAxis)o));
        }
    }

    public void showTimespan(final long duration, final TimeUnit timeUnit) {
        this.processX(new AbstractMouseHandler.AxisFunction<org.eclipse.scada.chart.XAxis>(){

            public void process(org.eclipse.scada.chart.XAxis axis) {
                axis.setByTimespan(duration, timeUnit);
            }
        });
    }

    public void pageTimespan(final long duration, final TimeUnit timeUnit) {
        this.processX(new AbstractMouseHandler.AxisFunction<org.eclipse.scada.chart.XAxis>(){

            public void process(org.eclipse.scada.chart.XAxis axis) {
                axis.shiftByTimespan(duration, timeUnit);
            }
        });
    }

    public void setNowCenter() {
        this.processX(new AbstractMouseHandler.AxisFunction<org.eclipse.scada.chart.XAxis>(){

            public void process(org.eclipse.scada.chart.XAxis axis) {
                axis.setNowCenter();
            }
        });
    }

    public Chart getChartConfiguration() {
        return this.chart;
    }

    private void handleDrop() {
        logger.debug("Handle drop");
        if (!this.mutable) {
            logger.debug("Drop, but we are not mutable");
            return;
        }
        ISelection selection = LocalSelectionTransfer.getTransfer().getSelection();
        List data = SelectionHelper.list((ISelection)selection, Item.class);
        if (!data.isEmpty()) {
            for (Item item : data) {
                Charts.addItem(this.chart, item);
            }
            return;
        }
        data = SelectionHelper.list((ISelection)selection, org.eclipse.scada.hd.ui.connection.data.Item.class);
        if (!data.isEmpty()) {
            for (org.eclipse.scada.hd.ui.connection.data.Item item : data) {
                Charts.addItem(this.chart, item);
            }
            return;
        }
    }
}

