/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ui.chart.viewer;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.databinding.EMFObservables;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.scada.da.ui.connection.data.Item;
import org.eclipse.scada.ui.chart.model.ChartPackage;
import org.eclipse.scada.ui.chart.model.DataItemSeries;
import org.eclipse.scada.ui.chart.model.IdItem;
import org.eclipse.scada.ui.chart.model.Item;
import org.eclipse.scada.ui.chart.model.ItemDataSeries;
import org.eclipse.scada.ui.chart.model.UriItem;
import org.eclipse.scada.ui.chart.model.XAxis;
import org.eclipse.scada.ui.chart.model.YAxis;
import org.eclipse.scada.ui.chart.viewer.AbstractItemInputViewer;
import org.eclipse.scada.ui.chart.viewer.AxisLocator;
import org.eclipse.scada.ui.chart.viewer.ChartViewer;
import org.eclipse.scada.ui.chart.viewer.LinePropertiesBinder;
import org.eclipse.scada.ui.chart.viewer.XAxisViewer;
import org.eclipse.scada.ui.chart.viewer.YAxisViewer;
import org.eclipse.scada.ui.chart.viewer.input.ChartInput;
import org.eclipse.scada.ui.chart.viewer.input.ItemObserver;

public class DataItemSeriesViewer
extends AbstractItemInputViewer {
    public static final String PROP_INPUT = "input";
    private final IObservableValue inputObservable = BeansObservables.observeValue((Object)this, (String)"input");
    private final IObservableValue linePropertiesObservable;
    private ItemObserver input;

    public DataItemSeriesViewer(DataBindingContext dbc, DataItemSeries element, ChartViewer viewer, ResourceManager resourceManager, AxisLocator<XAxis, XAxisViewer> xLocator, AxisLocator<YAxis, YAxisViewer> yLocator) {
        super(dbc, (ItemDataSeries)element, viewer, resourceManager, xLocator, yLocator);
        this.linePropertiesObservable = EMFObservables.observeValue((EObject)element, (EStructuralFeature)ChartPackage.Literals.DATA_ITEM_SERIES__LINE_PROPERTIES);
        this.addBindings(LinePropertiesBinder.bind(dbc, this.inputObservable, this.linePropertiesObservable));
        this.setInputObserable(this.inputObservable);
    }

    @Override
    public void dispose() {
        this.inputObservable.dispose();
        this.linePropertiesObservable.dispose();
    }

    @Override
    protected void checkCreateInput() {
        if (this.item != null && this.xAxis != null && this.yAxis != null) {
            org.eclipse.scada.da.ui.connection.data.Item item = this.makeItem(this.item);
            if (item == null) {
                return;
            }
            ItemObserver input = new ItemObserver(this.viewer, item, this.viewer.getRealm(), this.xAxis.getAxis(), this.yAxis.getAxis(), this.resourceManager);
            this.viewer.addInput(input);
            this.setInput(input);
        }
    }

    private void setInput(ItemObserver input) {
        this.input = input;
        this.firePropertyChange(PROP_INPUT, this.input, this.input);
    }

    public ItemObserver getInput() {
        return this.input;
    }

    private org.eclipse.scada.da.ui.connection.data.Item makeItem(Item item) {
        if (item instanceof IdItem) {
            return new org.eclipse.scada.da.ui.connection.data.Item(((IdItem)item).getConnectionId(), item.getItemId(), Item.Type.ID);
        }
        if (item instanceof UriItem) {
            return new org.eclipse.scada.da.ui.connection.data.Item(((UriItem)item).getConnectionUri(), item.getItemId(), Item.Type.URI);
        }
        return null;
    }

    @Override
    public boolean provides(ChartInput input) {
        return this.input == input;
    }

    @Override
    protected void disposeInput() {
        if (this.input != null) {
            this.viewer.removeInput(this.input);
            this.input.dispose();
            this.setInput(null);
        }
    }
}

