/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ui.chart.viewer.input.composite;

import java.util.Map;
import org.eclipse.scada.chart.Realm;
import org.eclipse.scada.chart.WritableSeries;
import org.eclipse.scada.chart.XAxis;
import org.eclipse.scada.chart.YAxis;
import org.eclipse.scada.ui.chart.viewer.input.ArchiveInput;
import org.eclipse.scada.ui.chart.viewer.input.composite.CompositeSource;
import org.eclipse.scada.ui.chart.viewer.input.composite.MergeQualityData;

public class MergedSeries
extends WritableSeries {
    private long startTimestamp;
    private long endTimestamp;
    private int width;
    private final Map<ArchiveInput, CompositeSource> sources;

    public MergedSeries(Map<ArchiveInput, CompositeSource> sources, Realm realm, XAxis xAxis, YAxis yAxis) {
        super(realm, xAxis, yAxis);
        this.sources = sources;
        this.startTimestamp = xAxis.getMin();
        this.endTimestamp = xAxis.getMax();
    }

    public void setRequestWindow(long startTimestamp, long endTimestamp) {
        if (this.startTimestamp == startTimestamp && this.endTimestamp == endTimestamp) {
            return;
        }
        this.startTimestamp = startTimestamp;
        this.endTimestamp = endTimestamp;
        this.update();
    }

    public void setRequestWidth(int width) {
        if (this.width == width) {
            return;
        }
        this.width = width;
        this.update();
    }

    public void update() {
        MergeQualityData merger = new MergeQualityData(this.sources.values(), this.startTimestamp, this.endTimestamp, this.width);
        merger.merge();
        this.setData(merger.getData());
    }
}

