/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.generator.component;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.scada.configuration.component.ComponentWorld;
import org.eclipse.scada.configuration.generator.component.app.AlarmsInformationProcessor;
import org.eclipse.scada.configuration.generator.component.app.GeneratorProcessor;
import org.eclipse.scada.configuration.generator.component.app.MarkerGroupGeneratorProcessor;
import org.eclipse.scada.configuration.generator.component.app.SummariesCompressor;
import org.eclipse.scada.configuration.generator.component.app.SummariesItemsGenerator;
import org.eclipse.scada.configuration.generator.component.app.SummariesProcessor;
import org.eclipse.scada.configuration.globalization.Globalization;
import org.eclipse.scada.configuration.globalization.lib.GlobalizationProcessor;
import org.eclipse.scada.configuration.infrastructure.lib.WorldGenerator;
import org.eclipse.scada.configuration.utils.ModelLoader;
import org.eclipse.scada.configuration.world.World;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemRunner {
    private static final Logger logger = LoggerFactory.getLogger(SystemRunner.class);

    public World process(URI input, URI output, IProgressMonitor monitor) throws Exception {
        logger.debug("Processing file: {}", (Object)input);
        monitor.setTaskName("Loading model");
        ComponentWorld system = (ComponentWorld)new ModelLoader(ComponentWorld.class).load(input);
        WorldGenerator gen = new WorldGenerator(system.getInfrastructure());
        gen.generate(monitor);
        GlobalizationProcessor gb = this.createGlobalizationProcessor(gen.getGlobalize());
        if (gb != null) {
            gb.preProcess(monitor);
        }
        new GeneratorProcessor((EObject)system, gen).process(monitor);
        new SummariesProcessor(system, gen).process(monitor);
        new SummariesCompressor(system, gen).process(monitor);
        new SummariesItemsGenerator(system, gen).process(monitor);
        new MarkerGroupGeneratorProcessor(system, gen).process(monitor);
        new AlarmsInformationProcessor(system, gen).process(monitor);
        if (gb != null) {
            gb.postProcess(monitor);
        }
        if (output != null) {
            monitor.subTask("Writing model");
            ResourceSetImpl rs = new ResourceSetImpl();
            Resource r1 = rs.createResource(URI.createURI((String)(output + "/result.eswm")));
            r1.getContents().add((Object)gen.getWorld());
            Resource r2 = rs.createResource(URI.createURI((String)(output + "/result.globalize")));
            r2.getContents().add((Object)gen.getGlobalize());
            r1.save(null);
            r2.save(null);
        }
        return gen.getWorld();
    }

    private GlobalizationProcessor createGlobalizationProcessor(Globalization glob) {
        if (glob != null) {
            return new GlobalizationProcessor(glob);
        }
        return null;
    }
}

