/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.generator.component.app;

import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.scada.configuration.component.ComponentWorld;
import org.eclipse.scada.configuration.component.Configuration;
import org.eclipse.scada.configuration.component.lib.Configurations;
import org.eclipse.scada.configuration.infrastructure.EquinoxApplication;
import org.eclipse.scada.configuration.utils.TypeWalker;

public abstract class EquinoxApplicationProcessor<App extends EquinoxApplication> {
    private final Class<App> clazz;
    @Inject
    @Named(value="componentModel")
    protected ComponentWorld system;

    public EquinoxApplicationProcessor(Class<App> clazz) {
        this.clazz = clazz;
    }

    public EquinoxApplicationProcessor(Class<App> clazz, ComponentWorld system) {
        this.clazz = clazz;
        this.system = system;
    }

    public void process(IProgressMonitor monitor) throws Exception {
        List apps = new TypeWalker(this.clazz).toList((EObject)this.system.getInfrastructure());
        for (EquinoxApplication app : apps) {
            this.process(app, monitor);
        }
    }

    protected <T extends Configuration> T findDefaultConfiguration(Class<T> clazz) {
        return (T)Configurations.findDefaultConfiguration((ComponentWorld)this.system, clazz);
    }

    protected abstract void process(App var1, IProgressMonitor var2) throws Exception;
}

