/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.generator.component.app;

import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.scada.configuration.component.ComponentWorld;
import org.eclipse.scada.configuration.generator.GeneratorContext;
import org.eclipse.scada.configuration.generator.component.app.MasterApplicationProcessor;
import org.eclipse.scada.configuration.infrastructure.lib.WorldGenerator;
import org.eclipse.scada.configuration.world.osgi.Item;
import org.eclipse.scada.configuration.world.osgi.MasterServer;
import org.eclipse.scada.configuration.world.osgi.OsgiFactory;
import org.eclipse.scada.configuration.world.osgi.SummaryGroup;

public class SummariesProcessor
extends MasterApplicationProcessor {
    public SummariesProcessor() {
    }

    public SummariesProcessor(ComponentWorld system, WorldGenerator world) {
        super(system, world);
    }

    @Override
    public void processContext(GeneratorContext.MasterContext app, IProgressMonitor monitor) {
        for (Item item : app.getImplementation().getItems()) {
            this.processItem(app.getImplementation(), item);
        }
    }

    private void processItem(MasterServer app, Item item) {
        if (item.getInformation() == null) {
            return;
        }
        EList hier = item.getInformation().getHierarchy();
        if (hier.isEmpty()) {
            return;
        }
        SummaryGroup group = this.getSummaryGroup(null, (Collection<SummaryGroup>)app.getSummaryGroups(), new LinkedList<String>((Collection<String>)hier));
        if (group == null) {
            return;
        }
        group.getItems().add((Object)item);
    }

    private SummaryGroup getSummaryGroup(SummaryGroup parent, Collection<SummaryGroup> groups, LinkedList<String> hierarchy) {
        SummaryGroup group2;
        if (hierarchy.isEmpty()) {
            return parent;
        }
        String level = hierarchy.pollFirst();
        for (SummaryGroup group2 : groups) {
            if (!group2.getName().equals(level)) continue;
            return this.getSummaryGroup(group2, (Collection<SummaryGroup>)group2.getSubGroups(), hierarchy);
        }
        group2 = OsgiFactory.eINSTANCE.createSummaryGroup();
        group2.setName(level);
        groups.add(group2);
        return this.getSummaryGroup(group2, (Collection<SummaryGroup>)group2.getSubGroups(), hierarchy);
    }
}

