/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.lib;

import java.util.Iterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.scada.ae.data.Severity;
import org.eclipse.scada.configuration.lib.AttributesSummary;
import org.eclipse.scada.configuration.lib.ItemCustomizer;
import org.eclipse.scada.configuration.world.osgi.Block;
import org.eclipse.scada.configuration.world.osgi.BooleanMonitor;
import org.eclipse.scada.configuration.world.osgi.DataMapper;
import org.eclipse.scada.configuration.world.osgi.EventLogger;
import org.eclipse.scada.configuration.world.osgi.Item;
import org.eclipse.scada.configuration.world.osgi.ItemFeatureEntry;
import org.eclipse.scada.configuration.world.osgi.LevelMonitor;
import org.eclipse.scada.configuration.world.osgi.ManualOverride;
import org.eclipse.scada.configuration.world.osgi.OsgiFactory;
import org.eclipse.scada.configuration.world.osgi.Rounding;
import org.eclipse.scada.configuration.world.osgi.RoundingType;
import org.eclipse.scada.configuration.world.osgi.Scale;
import org.eclipse.scada.configuration.world.osgi.ValueMapper;

public class DefaultFeatures {
    public static final ItemCustomizer WRITE_LOGGER = DefaultFeatures.EVENT_LOGGER(true, true, false, false);
    public static final ItemCustomizer VALUE_LOGGER = DefaultFeatures.EVENT_LOGGER(false, false, true, false);
    public static final ItemCustomizer EVENT_LOGGER = DefaultFeatures.EVENT_LOGGER(true, true, true, true);
    public static ItemCustomizer MANUAL_OVERRIDE = DefaultFeatures.MANUAL_OVERRIDE(null);
    private static LevelMonitor DEFAULT_MIN = OsgiFactory.eINSTANCE.createLevelMonitor();
    private static LevelMonitor DEFAULT_MAX;
    private static LevelMonitor DEFAULT_HIGHHIGH;
    private static LevelMonitor DEFAULT_HIGH;
    private static LevelMonitor DEFAULT_LOW;
    private static LevelMonitor DEFAULT_LOWLOW;
    public static ItemCustomizer ASUM;
    public static ItemCustomizer BLOCK;

    static {
        DEFAULT_MIN.setCap(true);
        DEFAULT_MIN.setLowerOk(false);
        DEFAULT_MIN.setIncludedOk(true);
        DEFAULT_MIN.setPrefix("min");
        DEFAULT_MIN.setMonitorType("MIN");
        DEFAULT_MIN.setSeverity(Severity.ERROR);
        DEFAULT_MIN.setDemotePrefix("maintenance");
        DEFAULT_MAX = OsgiFactory.eINSTANCE.createLevelMonitor();
        DEFAULT_MAX.setCap(true);
        DEFAULT_MAX.setLowerOk(true);
        DEFAULT_MAX.setIncludedOk(true);
        DEFAULT_MAX.setPrefix("max");
        DEFAULT_MAX.setMonitorType("MAX");
        DEFAULT_MAX.setSeverity(Severity.ERROR);
        DEFAULT_MAX.setDemotePrefix("maintenance");
        DEFAULT_HIGHHIGH = OsgiFactory.eINSTANCE.createLevelMonitor();
        DEFAULT_HIGHHIGH.setCap(false);
        DEFAULT_HIGHHIGH.setLowerOk(true);
        DEFAULT_HIGHHIGH.setIncludedOk(false);
        DEFAULT_HIGHHIGH.setPrefix("highhigh");
        DEFAULT_HIGHHIGH.setMonitorType("HH");
        DEFAULT_HIGHHIGH.setSeverity(Severity.ALARM);
        DEFAULT_HIGHHIGH.setDemotePrefix("maintenance");
        DEFAULT_HIGH = OsgiFactory.eINSTANCE.createLevelMonitor();
        DEFAULT_HIGH.setCap(false);
        DEFAULT_HIGH.setLowerOk(true);
        DEFAULT_HIGH.setIncludedOk(false);
        DEFAULT_HIGH.setPrefix("high");
        DEFAULT_HIGH.setMonitorType("H");
        DEFAULT_HIGH.setSeverity(Severity.WARNING);
        DEFAULT_HIGH.setDemotePrefix("maintenance");
        DEFAULT_LOW = OsgiFactory.eINSTANCE.createLevelMonitor();
        DEFAULT_LOW.setCap(false);
        DEFAULT_LOW.setLowerOk(false);
        DEFAULT_LOW.setIncludedOk(false);
        DEFAULT_LOW.setPrefix("low");
        DEFAULT_LOW.setMonitorType("L");
        DEFAULT_LOW.setSeverity(Severity.WARNING);
        DEFAULT_LOW.setDemotePrefix("maintenance");
        DEFAULT_LOWLOW = OsgiFactory.eINSTANCE.createLevelMonitor();
        DEFAULT_LOWLOW.setCap(false);
        DEFAULT_LOWLOW.setLowerOk(false);
        DEFAULT_LOWLOW.setIncludedOk(false);
        DEFAULT_LOWLOW.setPrefix("lowlow");
        DEFAULT_LOWLOW.setMonitorType("LL");
        DEFAULT_LOWLOW.setSeverity(Severity.ALARM);
        DEFAULT_LOWLOW.setDemotePrefix("maintenance");
        ASUM = DefaultFeatures.ASUM(1);
        BLOCK = DefaultFeatures.BLOCK();
    }

    public static final ItemCustomizer EVENT_LOGGER(final boolean logWrites, final boolean logSubscriptionChange, final boolean logValueChange, final boolean logAttributesChange) {
        return new ItemCustomizer(){

            @Override
            public void customize(Item item) {
                EventLogger feature = OsgiFactory.eINSTANCE.createEventLogger();
                feature.setName("write.logger");
                feature.setLogWrites(logWrites);
                feature.setLogSubscriptionChange(logSubscriptionChange);
                feature.setLogValueChange(logValueChange);
                feature.setLogAttributesChange(logAttributesChange);
                DefaultFeatures.registerFeature(item, (ItemFeatureEntry)feature);
            }
        };
    }

    public static ItemCustomizer MANUAL_OVERRIDE(final String value) {
        return new ItemCustomizer(){

            @Override
            public void customize(Item item) {
                ManualOverride manualOverride = OsgiFactory.eINSTANCE.createManualOverride();
                manualOverride.setInitialValue(value);
                manualOverride.setName("local.manual");
                DefaultFeatures.registerFeature(item, (ItemFeatureEntry)manualOverride);
            }
        };
    }

    public static ItemCustomizer MIN(Double value) {
        return new LevelCustomizer("local.level.min", value, DEFAULT_MIN);
    }

    public static ItemCustomizer MAX(Double value) {
        return new LevelCustomizer("local.level.max", value, DEFAULT_MAX);
    }

    public static ItemCustomizer H(Double value) {
        return new LevelCustomizer("local.level.high", value, DEFAULT_HIGH);
    }

    public static ItemCustomizer HH(Double value) {
        return new LevelCustomizer("local.level.highhigh", value, DEFAULT_HIGHHIGH);
    }

    public static ItemCustomizer L(Double value) {
        return new LevelCustomizer("local.level.low", value, DEFAULT_LOW);
    }

    public static ItemCustomizer LL(Double value) {
        return new LevelCustomizer("local.level.lowlow", value, DEFAULT_LOWLOW);
    }

    public static ItemCustomizer ASUM(int level) {
        return new AttributesSummary(level);
    }

    public static ItemCustomizer ASUM() {
        return new AttributesSummary(1);
    }

    public static ItemCustomizer BOOL_MONITOR(final boolean referenceValue, final Severity severity, final boolean requireAck) {
        return new ItemCustomizer(){

            @Override
            public void customize(Item item) {
                BooleanMonitor feature = OsgiFactory.eINSTANCE.createBooleanMonitor();
                feature.setActive(true);
                feature.setReferenceValue(referenceValue);
                feature.setSeverity(severity);
                feature.setRequireAck(requireAck);
                feature.setName("local.bool.monitor");
                DefaultFeatures.registerFeature(item, (ItemFeatureEntry)feature);
            }
        };
    }

    public static ItemCustomizer SCALE(final Double factor, final Double offset) {
        return new ItemCustomizer(){

            @Override
            public void customize(Item item) {
                Scale feature = OsgiFactory.eINSTANCE.createScale();
                feature.setActive(factor != null || offset != null);
                feature.setFactor(factor);
                feature.setOffset(offset);
                feature.setName("local.scale");
                DefaultFeatures.registerFeature(item, (ItemFeatureEntry)feature);
            }
        };
    }

    public static ItemCustomizer ROUND(final RoundingType type) {
        return new ItemCustomizer(){

            @Override
            public void customize(Item item) {
                Rounding feature = OsgiFactory.eINSTANCE.createRounding();
                feature.setType(type == null ? RoundingType.NONE : type);
                feature.setName("local.rounding");
                DefaultFeatures.registerFeature(item, (ItemFeatureEntry)feature);
            }
        };
    }

    public static ItemCustomizer BLOCK() {
        return new ItemCustomizer(){

            @Override
            public void customize(Item item) {
                Block feature = OsgiFactory.eINSTANCE.createBlock();
                feature.setName("local.block");
                DefaultFeatures.registerFeature(item, (ItemFeatureEntry)feature);
            }
        };
    }

    public static void registerFeature(Item item, ItemFeatureEntry feature) {
        Iterator i = item.getItemFeatures().iterator();
        while (i.hasNext()) {
            ItemFeatureEntry entry = (ItemFeatureEntry)i.next();
            if (!entry.getName().equals(feature.getName())) continue;
            i.remove();
        }
        item.getItemFeatures().add((Object)feature);
    }

    public static ItemCustomizer MAPPER(final DataMapper mapper, final String sourceAttribute, final String targetAttribute) {
        return new ItemCustomizer(){

            @Override
            public void customize(Item item) {
                ValueMapper valueMapper = OsgiFactory.eINSTANCE.createValueMapper();
                valueMapper.setDataMapper(mapper);
                valueMapper.setName("value.mapper");
                valueMapper.setSourceAttribute(sourceAttribute);
                valueMapper.setTargetAttribute(targetAttribute);
                DefaultFeatures.registerFeature(item, (ItemFeatureEntry)valueMapper);
            }
        };
    }

    public static ItemCustomizer MAPPER(DataMapper mapper) {
        return DefaultFeatures.MAPPER(mapper, null, null);
    }

    private static final class LevelCustomizer
    implements ItemCustomizer {
        private final Double value;
        private final String name;
        private final LevelMonitor template;

        private LevelCustomizer(String name, Double value, LevelMonitor template) {
            this.name = name;
            this.value = value;
            this.template = template;
        }

        @Override
        public void customize(Item item) {
            LevelMonitor levelMonitor = (LevelMonitor)EcoreUtil.copy((EObject)this.template);
            levelMonitor.setName(this.name);
            levelMonitor.setPreset(this.value);
            DefaultFeatures.registerFeature(item, (ItemFeatureEntry)levelMonitor);
        }
    }
}

