/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.lib;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExclusiveGroups {
    private static final Logger logger = LoggerFactory.getLogger(ExclusiveGroups.class);
    private static final String VALUE_GROUP_ID = "groupId";
    private static final String SOURCE_NAME = "http://eclipse.org/SCADA/Configuration/World/ExclusiveGroup";

    private ExclusiveGroups() {
    }

    public static void removeGroups(Collection<? extends EObject> objects, Set<String> groupIds) {
        if (groupIds == null || groupIds.isEmpty()) {
            return;
        }
        Iterator<? extends EObject> i = objects.iterator();
        while (i.hasNext()) {
            String groupId;
            EObject obj = i.next();
            EAnnotation annotation = ExclusiveGroups.findAnnotation(obj);
            if (annotation == null || (groupId = (String)annotation.getDetails().get((Object)VALUE_GROUP_ID)) == null || !groupIds.contains(groupId)) continue;
            i.remove();
        }
    }

    public static EAnnotation findAnnotation(EObject target) {
        EAnnotation annotation = target.eClass().getEAnnotation(SOURCE_NAME);
        if (annotation != null) {
            logger.debug("Found direct annotation - target: {}, annotation: {}", (Object)target, (Object)annotation);
            return annotation;
        }
        for (EClass clazz : target.eClass().getEAllSuperTypes()) {
            logger.debug("Checking supertype: {}", (Object)clazz);
            annotation = clazz.getEAnnotation(SOURCE_NAME);
            if (annotation == null) continue;
            logger.debug("Found annotation - target: {}, superclass: {}, annotation: {}", new Object[]{target, clazz, annotation});
            return annotation;
        }
        logger.debug("Annotation on {} not found", (Object)target);
        return null;
    }

    public static Set<String> makeGroupIds(Collection<? extends EObject> objects) {
        HashSet<String> result = new HashSet<String>();
        for (EObject eObject : objects) {
            String groupId;
            EAnnotation annotation = ExclusiveGroups.findAnnotation(eObject);
            if (annotation == null || (groupId = (String)annotation.getDetails().get((Object)VALUE_GROUP_ID)) == null) continue;
            result.add(groupId);
        }
        return result;
    }

    public static void removeGroups(Collection<? extends EObject> objects, Collection<? extends EObject> sourceObjects) {
        ExclusiveGroups.removeGroups(objects, ExclusiveGroups.makeGroupIds(sourceObjects));
    }

    public static Map<String, Set<EObject>> validate(EList<? extends EObject> objects) {
        Map<String, Set<EObject>> map = ExclusiveGroups.aggregateGroups(objects);
        HashMap<String, Set<EObject>> result = new HashMap<String, Set<EObject>>();
        for (Map.Entry<String, Set<EObject>> entry : map.entrySet()) {
            if (entry.getValue().size() <= 1) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public static Map<String, Set<EObject>> aggregateGroups(EList<? extends EObject> objects) {
        HashMap<String, Set<EObject>> map = new HashMap<String, Set<EObject>>();
        for (EObject obj : objects) {
            String groupId;
            EAnnotation annotation = ExclusiveGroups.findAnnotation(obj);
            if (annotation == null || (groupId = (String)annotation.getDetails().get((Object)VALUE_GROUP_ID)) == null) continue;
            HashSet<EObject> set = (HashSet<EObject>)map.get(groupId);
            if (set == null) {
                set = new HashSet<EObject>();
                map.put(groupId, set);
            }
            set.add(obj);
        }
        return map;
    }
}

