/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.lib;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.scada.configuration.world.NamedDocumentable;
import org.eclipse.scada.configuration.world.osgi.Item;
import org.eclipse.scada.configuration.world.osgi.ItemInformation;
import org.eclipse.scada.configuration.world.osgi.SummaryGroup;
import org.eclipse.scada.utils.str.StringHelper;

public final class Names {
    public static final String delimiter = ".";

    private Names() {
    }

    public static String makeName(NamedDocumentable documentable) {
        if (documentable.getName() != null) {
            return documentable.getName();
        }
        return EcoreUtil.getID((EObject)documentable);
    }

    public static List<String> makeHierarchy(SummaryGroup group) {
        LinkedList<String> result = new LinkedList<String>();
        while (group != null) {
            result.add(0, group.getName());
            group = (SummaryGroup)(group.eContainer() instanceof SummaryGroup ? group.eContainer() : null);
        }
        return result;
    }

    public static String makeHierarchy(List<String> hierarchy) {
        return StringHelper.join(hierarchy, (String)delimiter);
    }

    public static String makeId(SummaryGroup group) {
        return Names.makeHierarchy(Names.makeHierarchy(group));
    }

    public static List<String> makeHierarchy(Item item) {
        ItemInformation info = item.getInformation();
        if (info == null) {
            return Collections.emptyList();
        }
        return info.getHierarchy();
    }
}

