/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.lib;

import org.eclipse.scada.configuration.world.Application;
import org.eclipse.scada.configuration.world.Endpoint;
import org.eclipse.scada.configuration.world.Node;

public final class Nodes {
    private static final String LOCALHOST = System.getProperty("org.eclipse.scada.configuration.lib.localhost", "localhost");

    private Nodes() {
    }

    public static boolean isLocal(Node node1, Node node2) {
        if (node1 == null || node2 == null) {
            return false;
        }
        return node1.getHostName().equalsIgnoreCase(node2.getHostName());
    }

    public static Node fromApp(Application app) {
        if (app == null) {
            return null;
        }
        if (!(app.eContainer() instanceof Node)) {
            return null;
        }
        return (Node)app.eContainer();
    }

    public static boolean isLocal(Node node1, Application app) {
        return Nodes.isLocal(node1, Nodes.fromApp(app));
    }

    public static boolean isLocal(Node node1, Endpoint ep) {
        return Nodes.isLocal(node1, ep.getNode());
    }

    public static boolean isLocal(Application app1, Endpoint ep) {
        return Nodes.isLocal(Nodes.fromApp(app1), ep.getNode());
    }

    public static boolean isLocal(Application app1, Application app2) {
        return Nodes.isLocal(Nodes.fromApp(app1), Nodes.fromApp(app2));
    }

    public static String makeName(Node node) {
        if (node == null) {
            return null;
        }
        if (node.getName() != null && !node.getName().isEmpty()) {
            return node.getName();
        }
        return node.getHostName();
    }

    public static String makeHostname(Application app, Node node) {
        if (Nodes.isLocal(Nodes.fromApp(app), node)) {
            return LOCALHOST;
        }
        return node.getHostName();
    }
}

