/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.lib;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.scada.configuration.world.PropertyEntry;
import org.eclipse.scada.configuration.world.WorldFactory;

public final class Properties {
    private Properties() {
    }

    public static PropertyEntry create(String key, String value) {
        PropertyEntry prop = WorldFactory.eINSTANCE.createPropertyEntry();
        prop.setKey(key);
        prop.setValue(value);
        return prop;
    }

    public static String getProperty(Collection<PropertyEntry> properties, String name, String defaultValue) {
        return Properties.get(properties, name, defaultValue);
    }

    public static String get(Collection<PropertyEntry> properties, String key, String defaultValue) {
        if (properties == null) {
            return defaultValue;
        }
        for (PropertyEntry pe : properties) {
            if (!pe.getKey().equals(key)) continue;
            return pe.getValue();
        }
        return defaultValue;
    }

    public static Map<String, String> makeAttributes(Collection<PropertyEntry> properties) {
        return Properties.makeAttributes(null, properties);
    }

    public static Map<String, String> makeAttributes(String prefix, Collection<PropertyEntry> properties) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (PropertyEntry entry : properties) {
            if (prefix != null) {
                result.put(String.valueOf(prefix) + entry.getKey(), entry.getValue());
                continue;
            }
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public static Boolean isProperty(Collection<PropertyEntry> properties, String name, Boolean defaultValue) {
        for (PropertyEntry pe : properties) {
            if (!pe.getKey().equals(name)) continue;
            return Boolean.parseBoolean(pe.getValue());
        }
        return defaultValue;
    }

    public static void putNonEmpty(Map<String, String> properties, String key, String value) {
        if (value != null && !value.isEmpty()) {
            properties.put(key, value);
        }
    }

    public static boolean isEmpty(PropertyEntry entry) {
        if (entry == null) {
            return true;
        }
        if (entry.getKey() == null || entry.getKey().isEmpty()) {
            return true;
        }
        return entry.getValue() == null || entry.getValue().isEmpty();
    }
}

